/*
 * Decompiled with CFR 0.152.
 */
package alluxio.metrics;

import alluxio.shaded.client.com.codahale.metrics.Reservoir;
import alluxio.shaded.client.com.codahale.metrics.Snapshot;
import java.io.OutputStream;
import java.util.concurrent.atomic.LongAccumulator;

public class MaxReservoir
implements Reservoir {
    private final Reservoir mDelegate;
    private final LongAccumulator mMaxUpdate = new LongAccumulator(Long::max, Long.MIN_VALUE);

    public MaxReservoir(Reservoir delegate) {
        this.mDelegate = delegate;
    }

    @Override
    public int size() {
        return this.mDelegate.size();
    }

    @Override
    public void update(long value) {
        this.mMaxUpdate.accumulate(value);
        this.mDelegate.update(value);
    }

    @Override
    public Snapshot getSnapshot() {
        return new MaxSnapshot(this.mDelegate.getSnapshot(), this.mMaxUpdate.get());
    }

    private static class MaxSnapshot
    extends Snapshot {
        private final Snapshot mDelegate;
        private final long mMax;

        private MaxSnapshot(Snapshot delegate, long max) {
            this.mDelegate = delegate;
            this.mMax = max;
        }

        @Override
        public double getValue(double quantile) {
            return this.mDelegate.getValue(quantile);
        }

        @Override
        public long[] getValues() {
            return this.mDelegate.getValues();
        }

        @Override
        public int size() {
            return this.mDelegate.size();
        }

        @Override
        public long getMax() {
            return this.mMax;
        }

        @Override
        public double getMean() {
            return this.mDelegate.getMean();
        }

        @Override
        public long getMin() {
            return this.mDelegate.getMin();
        }

        @Override
        public double getStdDev() {
            return this.mDelegate.getStdDev();
        }

        @Override
        public void dump(OutputStream output) {
            this.mDelegate.dump(output);
        }
    }
}

