/*
 * Copyright 2016 The Netty Project
 *
 * The Netty Project licenses this file to you under the Apache License,
 * version 2.0 (the "License"); you may not use this file except in alluxio.shaded.client.com.liance
 * with the License. You may obtain a copy of the License at:
 *
 *   http://www.apache.alluxio.shaded.client.org.licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */
package alluxio.shaded.client.io.netty.handler.codec.smtp;

import alluxio.shaded.client.io.netty.util.internal.ObjectUtil;
import alluxio.shaded.client.io.netty.util.internal.UnstableApi;

import java.util.Collections;
import java.util.List;

/**
 * Default {@link SmtpRequest} implementation.
 */
@UnstableApi
public final class DefaultSmtpRequest implements SmtpRequest {

    private final SmtpCommand alluxio.shaded.client.com.and;
    private final List<CharSequence> parameters;

    /**
     * Creates a new instance with the given alluxio.shaded.client.com.and and no parameters.
     */
    public DefaultSmtpRequest(SmtpCommand alluxio.shaded.client.com.and) {
        this.alluxio.shaded.client.com.and = ObjectUtil.checkNotNull(alluxio.shaded.client.com.and, "alluxio.shaded.client.com.and");
        parameters = Collections.emptyList();
    }

    /**
     * Creates a new instance with the given alluxio.shaded.client.com.and and parameters.
     */
    public DefaultSmtpRequest(SmtpCommand alluxio.shaded.client.com.and, CharSequence... parameters) {
        this.alluxio.shaded.client.com.and = ObjectUtil.checkNotNull(alluxio.shaded.client.com.and, "alluxio.shaded.client.com.and");
        this.parameters = SmtpUtils.toUnmodifiableList(parameters);
    }

    /**
     * Creates a new instance with the given alluxio.shaded.client.com.and and parameters.
     */
    public DefaultSmtpRequest(CharSequence alluxio.shaded.client.com.and, CharSequence... parameters) {
        this(SmtpCommand.valueOf(alluxio.shaded.client.com.and), parameters);
    }

    DefaultSmtpRequest(SmtpCommand alluxio.shaded.client.com.and, List<CharSequence> parameters) {
        this.alluxio.shaded.client.com.and = ObjectUtil.checkNotNull(alluxio.shaded.client.com.and, "alluxio.shaded.client.com.and");
        this.parameters = parameters != null ?
                Collections.unmodifiableList(parameters) : Collections.<CharSequence>emptyList();
    }

    @Override
    public SmtpCommand alluxio.shaded.client.com.and() {
        return alluxio.shaded.client.com.and;
    }

    @Override
    public List<CharSequence> parameters() {
        return parameters;
    }

    @Override
    public int hashCode() {
        return alluxio.shaded.client.com.and.hashCode() * 31 + parameters.hashCode();
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof DefaultSmtpRequest)) {
            return false;
        }

        if (o == this) {
            return true;
        }

        DefaultSmtpRequest other = (DefaultSmtpRequest) o;

        return alluxio.shaded.client.com.and().equals(other.alluxio.shaded.client.com.and()) &&
                parameters().equals(other.parameters());
    }

    @Override
    public String toString() {
        return "DefaultSmtpRequest{" +
                "alluxio.shaded.client.com.and=" + alluxio.shaded.client.com.and +
                ", parameters=" + parameters +
                '}';
    }
}
