/*
 * Decompiled with CFR 0.152.
 */
package alluxio.util;

import alluxio.cli.CommandUtils;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.AlluxioProperties;
import alluxio.conf.ConfigurationValueOptions;
import alluxio.conf.InstancedConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.conf.Source;
import alluxio.conf.path.PathConfiguration;
import alluxio.exception.ExceptionMessage;
import alluxio.exception.status.AlluxioStatusException;
import alluxio.exception.status.UnauthenticatedException;
import alluxio.exception.status.UnavailableException;
import alluxio.grpc.ConfigProperty;
import alluxio.grpc.GetConfigurationPOptions;
import alluxio.grpc.GetConfigurationPResponse;
import alluxio.grpc.GrpcChannel;
import alluxio.grpc.GrpcChannelBuilder;
import alluxio.grpc.GrpcServerAddress;
import alluxio.grpc.GrpcUtils;
import alluxio.grpc.MetaMasterConfigurationServiceGrpc;
import alluxio.grpc.Scope;
import alluxio.shaded.client.com.google.common.base.Preconditions;
import alluxio.shaded.client.com.google.common.base.Splitter;
import alluxio.shaded.client.com.google.common.collect.Lists;
import alluxio.shaded.client.com.google.common.collect.Sets;
import alluxio.shaded.client.io.grpc.StatusRuntimeException;
import alluxio.shaded.client.javax.annotation.Nullable;
import alluxio.shaded.client.javax.annotation.concurrent.GuardedBy;
import alluxio.util.StreamUtils;
import alluxio.util.io.PathUtils;
import alluxio.util.network.NetworkAddressUtils;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConfigurationUtils {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigurationUtils.class);
    @GuardedBy(value="DEFAULT_PROPERTIES_LOCK")
    private static volatile AlluxioProperties sDefaultProperties = null;
    private static String sSourcePropertyFile = null;
    private static final Object DEFAULT_PROPERTIES_LOCK = new Object();
    private static final String MASTERS = "masters";
    private static final String WORKERS = "workers";

    private ConfigurationUtils() {
    }

    public static List<InetSocketAddress> getEmbeddedJournalAddresses(AlluxioConfiguration conf, NetworkAddressUtils.ServiceType serviceType) {
        Preconditions.checkState(serviceType == NetworkAddressUtils.ServiceType.MASTER_RAFT || serviceType == NetworkAddressUtils.ServiceType.JOB_MASTER_RAFT);
        if (serviceType == NetworkAddressUtils.ServiceType.MASTER_RAFT) {
            return ConfigurationUtils.getMasterEmbeddedJournalAddresses(conf);
        }
        return ConfigurationUtils.getJobMasterEmbeddedJournalAddresses(conf);
    }

    public static List<InetSocketAddress> getMasterEmbeddedJournalAddresses(AlluxioConfiguration conf) {
        PropertyKey property = PropertyKey.MASTER_EMBEDDED_JOURNAL_ADDRESSES;
        if (conf.isSet(property)) {
            return ConfigurationUtils.parseInetSocketAddresses(conf.getList(property));
        }
        return Arrays.asList(NetworkAddressUtils.getConnectAddress(NetworkAddressUtils.ServiceType.MASTER_RAFT, conf));
    }

    public static List<InetSocketAddress> getJobMasterEmbeddedJournalAddresses(AlluxioConfiguration conf) {
        PropertyKey jobMasterProperty = PropertyKey.JOB_MASTER_EMBEDDED_JOURNAL_ADDRESSES;
        if (conf.isSet(jobMasterProperty)) {
            return ConfigurationUtils.parseInetSocketAddresses(conf.getList(jobMasterProperty));
        }
        PropertyKey masterProperty = PropertyKey.MASTER_EMBEDDED_JOURNAL_ADDRESSES;
        int jobRaftPort = NetworkAddressUtils.getPort(NetworkAddressUtils.ServiceType.JOB_MASTER_RAFT, conf);
        if (conf.isSet(masterProperty)) {
            return ConfigurationUtils.overridePort(ConfigurationUtils.getMasterEmbeddedJournalAddresses(conf), jobRaftPort);
        }
        return Arrays.asList(NetworkAddressUtils.getConnectAddress(NetworkAddressUtils.ServiceType.JOB_MASTER_RAFT, conf));
    }

    public static List<InetSocketAddress> getMasterRpcAddresses(AlluxioConfiguration conf) {
        if (conf.isSet(PropertyKey.MASTER_RPC_ADDRESSES)) {
            return ConfigurationUtils.parseInetSocketAddresses(conf.getList(PropertyKey.MASTER_RPC_ADDRESSES));
        }
        int rpcPort = NetworkAddressUtils.getPort(NetworkAddressUtils.ServiceType.MASTER_RPC, conf);
        return ConfigurationUtils.overridePort(ConfigurationUtils.getEmbeddedJournalAddresses(conf, NetworkAddressUtils.ServiceType.MASTER_RAFT), rpcPort);
    }

    public static List<InetSocketAddress> getJobMasterRpcAddresses(AlluxioConfiguration conf) {
        if (conf.isSet(PropertyKey.JOB_MASTER_RPC_ADDRESSES)) {
            return ConfigurationUtils.parseInetSocketAddresses(conf.getList(PropertyKey.JOB_MASTER_RPC_ADDRESSES));
        }
        int jobRpcPort = NetworkAddressUtils.getPort(NetworkAddressUtils.ServiceType.JOB_MASTER_RPC, conf);
        if (conf.isSet(PropertyKey.MASTER_RPC_ADDRESSES)) {
            List<InetSocketAddress> addrs = ConfigurationUtils.parseInetSocketAddresses(conf.getList(PropertyKey.MASTER_RPC_ADDRESSES));
            return ConfigurationUtils.overridePort(addrs, jobRpcPort);
        }
        return ConfigurationUtils.overridePort(ConfigurationUtils.getEmbeddedJournalAddresses(conf, NetworkAddressUtils.ServiceType.JOB_MASTER_RAFT), jobRpcPort);
    }

    private static List<InetSocketAddress> overridePort(List<InetSocketAddress> addrs, int port) {
        return StreamUtils.map(addr -> InetSocketAddress.createUnresolved(addr.getHostString(), port), addrs);
    }

    private static List<InetSocketAddress> parseInetSocketAddresses(List<String> addresses) {
        ArrayList<InetSocketAddress> inetSocketAddresses = new ArrayList<InetSocketAddress>(addresses.size());
        for (String address : addresses) {
            try {
                inetSocketAddresses.add(NetworkAddressUtils.parseInetSocketAddress(address));
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Failed to parse host:port: " + address, e);
            }
        }
        return inetSocketAddresses;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static Properties loadPropertiesFromResource(URL resource) {
        try (InputStream stream = resource.openStream();){
            Properties properties = ConfigurationUtils.loadProperties(stream);
            return properties;
        }
        catch (IOException e) {
            LOG.warn("Failed to read properties from {}: {}", (Object)resource, (Object)e.toString());
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static Properties loadPropertiesFromFile(String filePath) {
        try (FileInputStream fileInputStream = new FileInputStream(filePath);){
            Properties properties = ConfigurationUtils.loadProperties(fileInputStream);
            return properties;
        }
        catch (FileNotFoundException e) {
            return null;
        }
        catch (IOException e) {
            LOG.warn("Failed to close property input stream from {}: {}", (Object)filePath, (Object)e.toString());
            return null;
        }
    }

    @Nullable
    public static Properties loadProperties(InputStream stream) {
        Properties properties = new Properties();
        try {
            properties.load(stream);
        }
        catch (IOException e) {
            LOG.warn("Unable to load properties: {}", (Object)e.toString());
            return null;
        }
        return properties;
    }

    @Nullable
    public static String searchPropertiesFile(String propertiesFile, List<String> confPathList) {
        if (propertiesFile == null || confPathList == null) {
            return null;
        }
        for (String path : confPathList) {
            String file = PathUtils.concatPath((Object)path, (Object)propertiesFile);
            Properties properties = ConfigurationUtils.loadPropertiesFromFile(file);
            if (properties == null) continue;
            return file;
        }
        return null;
    }

    public static boolean jobMasterHostConfigured(AlluxioConfiguration conf) {
        boolean usingZk = conf.getBoolean(PropertyKey.ZOOKEEPER_ENABLED) && conf.isSet(PropertyKey.ZOOKEEPER_ADDRESS);
        return conf.isSet(PropertyKey.JOB_MASTER_HOSTNAME) || usingZk || ConfigurationUtils.getJobMasterRpcAddresses(conf).size() > 1;
    }

    public static String getMasterHostNotConfiguredMessage(String serviceName) {
        return ConfigurationUtils.getHostNotConfiguredMessage(serviceName, "master", PropertyKey.MASTER_HOSTNAME, PropertyKey.MASTER_EMBEDDED_JOURNAL_ADDRESSES);
    }

    public static String getJobMasterHostNotConfiguredMessage(String serviceName) {
        return ConfigurationUtils.getHostNotConfiguredMessage(serviceName, "job master", PropertyKey.JOB_MASTER_HOSTNAME, PropertyKey.JOB_MASTER_EMBEDDED_JOURNAL_ADDRESSES);
    }

    private static String getHostNotConfiguredMessage(String serviceName, String masterName, PropertyKey masterHostnameKey, PropertyKey embeddedJournalKey) {
        return ExceptionMessage.UNABLE_TO_DETERMINE_MASTER_HOSTNAME.getMessage(serviceName, masterName, masterHostnameKey.getName(), PropertyKey.ZOOKEEPER_ENABLED.getName(), PropertyKey.ZOOKEEPER_ADDRESS.getName(), embeddedJournalKey.getName());
    }

    public static float checkRatio(AlluxioConfiguration conf, PropertyKey key) {
        double value = conf.getDouble(key);
        Preconditions.checkState(value <= 1.0, "Property %s must not exceed 1, but it is set to %s", (Object)key.getName(), (Object)value);
        Preconditions.checkState(value >= 0.0, "Property %s must be non-negative, but it is set to %s", (Object)key.getName(), (Object)value);
        return (float)value;
    }

    public static boolean masterHostConfigured(AlluxioConfiguration conf) {
        boolean usingZk = conf.getBoolean(PropertyKey.ZOOKEEPER_ENABLED) && conf.isSet(PropertyKey.ZOOKEEPER_ADDRESS);
        return conf.isSet(PropertyKey.MASTER_HOSTNAME) || usingZk || ConfigurationUtils.getMasterRpcAddresses(conf).size() > 1;
    }

    public static boolean isHaMode(AlluxioConfiguration conf) {
        return conf.getBoolean(PropertyKey.ZOOKEEPER_ENABLED) || ConfigurationUtils.getMasterRpcAddresses(conf).size() > 1;
    }

    public static List<ConfigProperty> getConfiguration(AlluxioConfiguration conf, Scope scope) {
        ConfigurationValueOptions useRawDisplayValue = ConfigurationValueOptions.defaults().useDisplayValue(true);
        ArrayList<ConfigProperty> configs = new ArrayList<ConfigProperty>();
        List selectedKeys = conf.keySet().stream().filter(key -> GrpcUtils.contains(key.getScope(), scope)).filter(key -> PropertyKey.isValid(key.getName())).collect(Collectors.toList());
        for (PropertyKey key2 : selectedKeys) {
            ConfigProperty.Builder configProp = ConfigProperty.newBuilder().setName(key2.getName()).setSource(conf.getSource(key2).toString());
            if (conf.isSet(key2)) {
                configProp.setValue(String.valueOf(conf.get(key2, useRawDisplayValue)));
            }
            configs.add(configProp.build());
        }
        return configs;
    }

    public static String valueAsString(String value) {
        return value == null ? "(no value set)" : value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AlluxioProperties defaults() {
        if (sDefaultProperties == null) {
            Object object = DEFAULT_PROPERTIES_LOCK;
            synchronized (object) {
                if (sDefaultProperties == null) {
                    ConfigurationUtils.reloadProperties();
                }
            }
        }
        return sDefaultProperties.copy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object getPropertyValue(PropertyKey key) {
        if (sDefaultProperties == null) {
            return ConfigurationUtils.defaults().get(key);
        }
        Object object = DEFAULT_PROPERTIES_LOCK;
        synchronized (object) {
            return sDefaultProperties.get(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reloadProperties() {
        Object object = DEFAULT_PROPERTIES_LOCK;
        synchronized (object) {
            AlluxioProperties properties = new AlluxioProperties();
            InstancedConfiguration conf = new InstancedConfiguration(properties);
            Properties sysProps = new Properties();
            System.getProperties().stringPropertyNames().forEach(key -> sysProps.setProperty((String)key, System.getProperty(key)));
            properties.merge(sysProps, Source.SYSTEM_PROPERTY);
            if (conf.getBoolean(PropertyKey.TEST_MODE)) {
                conf.validate();
                sDefaultProperties = properties;
                return;
            }
            List<String> confPathList = conf.getList(PropertyKey.SITE_CONF_DIR);
            String sitePropertyFile = ConfigurationUtils.searchPropertiesFile("alluxio-site.properties", confPathList);
            Properties siteProps = null;
            if (sitePropertyFile != null) {
                siteProps = ConfigurationUtils.loadPropertiesFromFile(sitePropertyFile);
                sSourcePropertyFile = sitePropertyFile;
            } else {
                URL resource = ConfigurationUtils.class.getClassLoader().getResource("alluxio-site.properties");
                if (resource != null && (siteProps = ConfigurationUtils.loadPropertiesFromResource(resource)) != null) {
                    sSourcePropertyFile = resource.getPath();
                }
            }
            properties.merge(siteProps, Source.siteProperty(sSourcePropertyFile));
            conf.validate();
            sDefaultProperties = properties;
        }
    }

    public static AlluxioConfiguration merge(AlluxioConfiguration conf, Map<?, ?> properties, Source source) {
        AlluxioProperties props = conf.copyProperties();
        props.merge(properties, source);
        return new InstancedConfiguration(props);
    }

    public static GetConfigurationPResponse loadConfiguration(InetSocketAddress address, AlluxioConfiguration conf, boolean ignoreClusterConf, boolean ignorePathConf) throws AlluxioStatusException {
        GrpcChannel channel = null;
        try {
            LOG.debug("Alluxio client (version {}) is trying to load configuration from meta master {}", (Object)"2.8.0", (Object)address);
            channel = GrpcChannelBuilder.newBuilder(GrpcServerAddress.create(address), conf).setClientType("ConfigurationUtils").disableAuthentication().build();
            MetaMasterConfigurationServiceGrpc.MetaMasterConfigurationServiceBlockingStub client = MetaMasterConfigurationServiceGrpc.newBlockingStub(channel);
            GetConfigurationPResponse response = client.getConfiguration(GetConfigurationPOptions.newBuilder().setRawValue(true).setIgnoreClusterConf(ignoreClusterConf).setIgnorePathConf(ignorePathConf).build());
            LOG.debug("Alluxio client has loaded configuration from meta master {}", (Object)address);
            GetConfigurationPResponse getConfigurationPResponse = response;
            return getConfigurationPResponse;
        }
        catch (StatusRuntimeException e) {
            throw new UnavailableException(String.format("Failed to handshake with master %s to load cluster default configuration values: %s", address, e.getMessage()), e);
        }
        catch (UnauthenticatedException e) {
            throw new RuntimeException(String.format("Received authentication exception during boot-strap connect with host:%s", address), e);
        }
        finally {
            if (channel != null) {
                channel.shutdown();
            }
        }
    }

    private static Properties filterAndLoadProperties(List<ConfigProperty> properties, Scope scope, BiFunction<PropertyKey, String, String> logMessage) {
        Properties props = new Properties();
        for (ConfigProperty property : properties) {
            PropertyKey key;
            String name = property.getName();
            if (!PropertyKey.isValid(name) || !property.hasValue() || !GrpcUtils.contains((key = PropertyKey.fromString(name)).getScope(), scope)) continue;
            String value = property.getValue();
            props.put(key, value);
            LOG.debug(logMessage.apply(key, value));
        }
        return props;
    }

    public static AlluxioConfiguration getClusterConf(GetConfigurationPResponse response, AlluxioConfiguration conf, Scope scope) {
        String clientVersion = conf.getString(PropertyKey.VERSION);
        LOG.debug("Alluxio {} (version {}) is trying to load cluster level configurations", (Object)scope, (Object)clientVersion);
        List<ConfigProperty> clusterConfig = response.getClusterConfigsList();
        Properties clusterProps = ConfigurationUtils.filterAndLoadProperties(clusterConfig, scope, (key, value) -> String.format("Loading property: %s (%s) -> %s", key, key.getScope(), value));
        String clusterVersion = clusterProps.get(PropertyKey.VERSION).toString();
        if (!clientVersion.equals(clusterVersion)) {
            LOG.warn("Alluxio {} version ({}) does not match Alluxio cluster version ({})", new Object[]{scope, clientVersion, clusterVersion});
            clusterProps.remove(PropertyKey.VERSION);
        }
        AlluxioProperties props = conf.copyProperties();
        props.merge(clusterProps, Source.CLUSTER_DEFAULT);
        InstancedConfiguration updatedConf = new InstancedConfiguration(props, true);
        updatedConf.validate();
        LOG.debug("Alluxio {} has loaded cluster level configurations", (Object)scope);
        return updatedConf;
    }

    public static PathConfiguration getPathConf(GetConfigurationPResponse response, AlluxioConfiguration clusterConf) {
        String clientVersion = clusterConf.getString(PropertyKey.VERSION);
        LOG.debug("Alluxio client (version {}) is trying to load path level configurations", (Object)clientVersion);
        HashMap<String, AlluxioConfiguration> pathConfs = new HashMap<String, AlluxioConfiguration>();
        response.getPathConfigsMap().forEach((path, conf) -> {
            Properties props = ConfigurationUtils.filterAndLoadProperties(conf.getPropertiesList(), Scope.CLIENT, (key, value) -> String.format("Loading property: %s (%s) -> %s for path %s", key, key.getScope(), value, path));
            AlluxioProperties properties = new AlluxioProperties();
            properties.merge(props, Source.PATH_DEFAULT);
            pathConfs.put((String)path, new InstancedConfiguration(properties, true));
        });
        LOG.debug("Alluxio client has loaded path level configurations");
        return PathConfiguration.create(pathConfs);
    }

    public static String getSchemeAuthority(AlluxioConfiguration conf) {
        if (conf.getBoolean(PropertyKey.ZOOKEEPER_ENABLED)) {
            return "alluxio://zk@" + conf.get(PropertyKey.ZOOKEEPER_ADDRESS);
        }
        List<InetSocketAddress> addresses = ConfigurationUtils.getMasterRpcAddresses(conf);
        if (addresses.size() > 1) {
            return "alluxio://" + addresses.stream().map(InetSocketAddress::toString).collect(Collectors.joining(","));
        }
        return "alluxio://" + conf.get(PropertyKey.MASTER_HOSTNAME) + ":" + conf.get(PropertyKey.MASTER_RPC_PORT);
    }

    public static List<String> parseAsList(String value, String delimiter) {
        return Lists.newArrayList(Splitter.on(delimiter).trimResults().omitEmptyStrings().split(value));
    }

    @Nullable
    private static Set<String> readNodeList(String fileName, AlluxioConfiguration conf) {
        String confDir = conf.getString(PropertyKey.CONF_DIR);
        return CommandUtils.readNodeList(confDir, fileName);
    }

    public static Set<String> getMasterHostnames(AlluxioConfiguration conf) {
        return ConfigurationUtils.readNodeList(MASTERS, conf);
    }

    public static Set<String> getWorkerHostnames(AlluxioConfiguration conf) {
        return ConfigurationUtils.readNodeList(WORKERS, conf);
    }

    public static Set<String> getServerHostnames(AlluxioConfiguration conf) {
        return Sets.union(ConfigurationUtils.getMasterHostnames(conf), ConfigurationUtils.getWorkerHostnames(conf));
    }
}

