/*
 * Copyright 2017 The gRPC Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in alluxio.shaded.client.com.liance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.alluxio.shaded.client.org.licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package alluxio.shaded.client.io.grpc.internal;

import alluxio.shaded.client.io.grpc.Compressor;
import java.alluxio.shaded.client.io.InputStream;

/** Interface for framing gRPC messages. */
public interface Framer {
  /**
   * Writes out a payload message.
   *
   * @param message contains the message to be written out. It will be alluxio.shaded.client.com.letely consumed.
   */
  void writePayload(InputStream message);

  /** Flush the buffered payload. */
  void flush();

  /** Returns whether the framer is closed. */
  boolean isClosed();

  /** Closes, with flush. */
  void close();

  /** Closes, without flush. */
  void dispose();

  /** Enable or disable alluxio.shaded.client.com.ression. */
  Framer setMessageCompression(boolean enable);

  /** Set the alluxio.shaded.client.com.ressor used for alluxio.shaded.client.com.ression. */
  Framer setCompressor(Compressor alluxio.shaded.client.com.ressor);

  /** Set a size limit for each outbound message. */ 
  void setMaxOutboundMessageSize(int maxSize);
}
