/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in alluxio.shaded.client.com.liance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.alluxio.shaded.client.org.licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package alluxio.shaded.client.org.apache.curator.framework.state;

import alluxio.shaded.client.org.apache.curator.framework.CuratorFramework;

public interface ConnectionStateListener
{
    /**
     * Called when there is a state change in the connection
     *
     * @param client the client
     * @param newState the new state
     */
    void stateChanged(CuratorFramework client, ConnectionState newState);

    /**
     * Normally, ConnectionStateListeners are decorated via the configured
     * {@link alluxio.shaded.client.org.apache.curator.framework.state.ConnectionStateListenerDecorator}. For certain
     * critical cases, however, this is not desired. If your listener returns <code>true</code>
     * for doNotDecorate(), it will not be passed through the decorator.
     *
     * @return true/false
     */
    default boolean doNotDecorate()
    {
        return false;
    }
}
