/*
 * Decompiled with CFR 0.152.
 */
package alluxio.grpc;

import alluxio.retry.ExponentialBackoffRetry;
import alluxio.retry.RetryUtils;
import alluxio.security.authentication.AuthenticationServer;
import alluxio.shaded.client.com.google.common.annotations.VisibleForTesting;
import alluxio.shaded.client.com.google.common.base.MoreObjects;
import alluxio.shaded.client.com.google.common.io.Closer;
import alluxio.shaded.client.io.grpc.Server;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GrpcServer {
    private static final Logger LOG = LoggerFactory.getLogger(GrpcServer.class);
    private final Server mServer;
    private final AuthenticationServer mAuthServer;
    private final Closer mCloser;
    private volatile boolean mStarted = false;
    private final long mServerShutdownTimeoutMs;

    public GrpcServer(Server server, AuthenticationServer authServer, Closer closer, long serverShutdownTimeoutMs) {
        this.mServer = server;
        this.mAuthServer = authServer;
        this.mCloser = closer;
        this.mServerShutdownTimeoutMs = serverShutdownTimeoutMs;
    }

    @VisibleForTesting
    public AuthenticationServer getAuthenticationServer() {
        return this.mAuthServer;
    }

    public GrpcServer start() throws IOException {
        RetryUtils.retry("Starting gRPC server", this.mServer::start, new ExponentialBackoffRetry(100, 500, 5));
        this.mStarted = true;
        return this;
    }

    public int getBindPort() {
        return this.mServer.getPort();
    }

    public boolean shutdown() {
        this.mServer.shutdown();
        try {
            this.mCloser.close();
        }
        catch (IOException e) {
            LOG.error("Failed to close resources during shutdown.", (Throwable)e);
        }
        this.mServer.shutdownNow();
        try {
            return this.mServer.awaitTermination(this.mServerShutdownTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            return false;
        }
    }

    public void awaitTermination() {
        try {
            this.mServer.awaitTermination();
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
        }
    }

    public boolean isServing() {
        return this.mStarted && !this.mServer.isShutdown() || !this.mServer.isTerminated();
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("InternalServer", this.mServer).add("AuthServerType", this.mAuthServer.getClass().getSimpleName()).toString();
    }
}

