/*
 * Decompiled with CFR 0.152.
 */
package alluxio.security.authentication.plain;

import alluxio.security.authentication.AuthenticatedClientUser;
import alluxio.shaded.client.com.google.common.base.Preconditions;
import alluxio.shaded.client.javax.annotation.Nullable;
import alluxio.shaded.client.javax.annotation.concurrent.NotThreadSafe;
import alluxio.shaded.client.javax.annotation.concurrent.ThreadSafe;
import java.util.Map;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.sasl.AuthorizeCallback;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import javax.security.sasl.SaslServerFactory;

@NotThreadSafe
public final class PlainSaslServer
implements SaslServer {
    private String mAuthorizationId;
    private boolean mCompleted = false;
    private CallbackHandler mHandler;

    PlainSaslServer(CallbackHandler handler) throws SaslException {
        this.mHandler = handler;
    }

    @Override
    public String getMechanismName() {
        return "PLAIN";
    }

    @Override
    @Nullable
    public byte[] evaluateResponse(byte[] response) throws SaslException {
        Preconditions.checkState(!this.mCompleted, "PLAIN authentication has completed");
        Preconditions.checkArgument(response != null, "Received null response");
        try {
            String payload;
            try {
                payload = new String(response, "UTF-8");
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Received corrupt response", e);
            }
            String[] parts = payload.split("\u0000", 3);
            if (parts.length != 3) {
                throw new IllegalArgumentException("Invalid message format, parts must contain 3 items");
            }
            String authorizationId = parts[0];
            String authenticationId = parts[1];
            String passwd = parts[2];
            Preconditions.checkState(authenticationId != null && !authenticationId.isEmpty(), "No authentication identity provided");
            Preconditions.checkState(passwd != null && !passwd.isEmpty(), "No password provided");
            if (authorizationId == null || authorizationId.isEmpty()) {
                authorizationId = authenticationId;
            }
            NameCallback nameCallback = new NameCallback("User");
            nameCallback.setName(authenticationId);
            PasswordCallback passwordCallback = new PasswordCallback("Password", false);
            passwordCallback.setPassword(passwd.toCharArray());
            AuthorizeCallback authCallback = new AuthorizeCallback(authenticationId, authorizationId);
            Callback[] cbList = new Callback[]{nameCallback, passwordCallback, authCallback};
            this.mHandler.handle(cbList);
            if (!authCallback.isAuthorized()) {
                throw new SaslException("AuthorizeCallback authorized failure");
            }
            this.mAuthorizationId = authCallback.getAuthorizedID();
        }
        catch (Exception e) {
            throw new SaslException("Plain authentication failed: " + e.getMessage(), e);
        }
        this.mCompleted = true;
        return null;
    }

    @Override
    public boolean isComplete() {
        return this.mCompleted;
    }

    @Override
    public String getAuthorizationID() {
        this.checkNotComplete();
        return this.mAuthorizationId;
    }

    @Override
    public byte[] unwrap(byte[] incoming, int offset, int len) {
        throw new UnsupportedOperationException("PLAIN doesn't support wrap or unwrap operation");
    }

    @Override
    public byte[] wrap(byte[] outgoing, int offset, int len) {
        throw new UnsupportedOperationException("PLAIN doesn't support wrap or unwrap operation");
    }

    @Override
    @Nullable
    public Object getNegotiatedProperty(String propName) {
        this.checkNotComplete();
        return "javax.security.sasl.qop".equals(propName) ? "auth" : null;
    }

    @Override
    public void dispose() {
        if (this.mCompleted) {
            AuthenticatedClientUser.remove();
        }
        this.mCompleted = false;
        this.mHandler = null;
        this.mAuthorizationId = null;
    }

    private void checkNotComplete() {
        if (!this.mCompleted) {
            throw new IllegalStateException("PLAIN authentication not completed");
        }
    }

    @ThreadSafe
    public static class Factory
    implements SaslServerFactory {
        @Override
        public SaslServer createSaslServer(String mechanism, String protocol, String serverName, Map<String, ?> props, CallbackHandler callbackHandler) throws SaslException {
            Preconditions.checkArgument("PLAIN".equals(mechanism));
            return new PlainSaslServer(callbackHandler);
        }

        @Override
        public String[] getMechanismNames(Map<String, ?> props) {
            return new String[]{"PLAIN"};
        }
    }
}

