/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.file.cache.evictor;

import alluxio.client.file.cache.PageId;
import alluxio.client.file.cache.evictor.CacheEvictorOptions;
import alluxio.client.file.cache.evictor.LRUCacheEvictor;
import alluxio.client.file.cache.evictor.NondeterministicLRUCacheEvictor;
import alluxio.shaded.client.javax.annotation.Nullable;
import alluxio.shaded.client.javax.annotation.concurrent.ThreadSafe;
import alluxio.util.CommonUtils;
import java.util.function.Predicate;

@ThreadSafe
public interface CacheEvictor {
    public static CacheEvictor create(CacheEvictorOptions options) {
        if (options.isNondeterministic() && options.getEvictorClass().equals(LRUCacheEvictor.class)) {
            return new NondeterministicLRUCacheEvictor(options);
        }
        return CommonUtils.createNewClassInstance(options.getEvictorClass(), new Class[]{CacheEvictorOptions.class}, new Object[]{options});
    }

    public void updateOnGet(PageId var1);

    public void updateOnPut(PageId var1);

    public void updateOnDelete(PageId var1);

    @Nullable
    public PageId evict();

    @Nullable
    public PageId evictMatching(Predicate<PageId> var1);

    public void reset();
}

