/*
 * Decompiled with CFR 0.152.
 */
package alluxio.master.selectionpolicy;

import alluxio.exception.status.UnavailableException;
import alluxio.master.MasterInquireClient;
import alluxio.master.selectionpolicy.SelectionPolicyAnyMaster;
import alluxio.master.selectionpolicy.SelectionPolicyAnyStandbyMaster;
import alluxio.master.selectionpolicy.SelectionPolicyPrimaryMaster;
import alluxio.master.selectionpolicy.SelectionPolicySpecifiedMaster;
import java.net.InetSocketAddress;

public interface MasterSelectionPolicy {
    public InetSocketAddress getPrimaryMasterAddressCached(MasterInquireClient var1) throws UnavailableException;

    public InetSocketAddress getGrpcMasterAddress(MasterInquireClient var1) throws UnavailableException;

    public void resetPrimaryMasterAddressCache();

    public static class Factory {
        public static MasterSelectionPolicy primaryMaster() {
            return new SelectionPolicyPrimaryMaster();
        }

        public static MasterSelectionPolicy anyStandbyMaster() {
            return new SelectionPolicyAnyStandbyMaster();
        }

        public static MasterSelectionPolicy anyStandbyMaster(long randomSeed) {
            return new SelectionPolicyAnyStandbyMaster(randomSeed);
        }

        public static MasterSelectionPolicy anyMaster() {
            return new SelectionPolicyAnyMaster();
        }

        public static MasterSelectionPolicy specifiedMaster(InetSocketAddress masterAddress) {
            return new SelectionPolicySpecifiedMaster(masterAddress);
        }
    }
}

