/*
 * Decompiled with CFR 0.152.
 */
package alluxio.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.LongAdder;

public class BucketCounter {
    private Map<Long, LongAdder> mCounter = new HashMap<Long, LongAdder>();
    private List<Long> mIntervals;

    public BucketCounter(List<Long> intervals) {
        this.mIntervals = new ArrayList<Long>(intervals);
        this.mIntervals.add(Long.MAX_VALUE);
        for (Long interval : intervals) {
            this.mCounter.put(interval, new LongAdder());
        }
        this.mCounter.put(Long.MAX_VALUE, new LongAdder());
    }

    private LongAdder getStartInterval(Long value) {
        for (int i = 0; i < this.mIntervals.size(); ++i) {
            if (this.mIntervals.get(i) < value) continue;
            return this.mCounter.get(this.mIntervals.get(i));
        }
        return this.mCounter.get(Long.MAX_VALUE);
    }

    public void insert(Long number) {
        this.getStartInterval(number).increment();
    }

    public void remove(Long number) {
        this.getStartInterval(number).decrement();
    }

    public Map<Long, Number> getCounters() {
        return new HashMap<Long, Number>(this.mCounter);
    }
}

