/*
 * Copyright (C) 2011 The Guava Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in alluxio.shaded.client.com.liance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.alluxio.shaded.client.org.licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the
 * License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
 * express or implied. See the License for the specific language governing permissions and
 * limitations under the License.
 */

package alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.collect;

import static alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.base.Preconditions.checkNotNull;

import alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.annotations.GwtCompatible;
import java.util.Comparator;
import java.util.SortedSet;
import alluxio.shaded.client.org.checkerframework.checker.nullness.qual.Nullable;

/**
 * Utilities for dealing with sorted collections of all types.
 *
 * @author Louis Wasserman
 */
@GwtCompatible
@ElementTypesAreNonnullByDefault
final class SortedIterables {
  private SortedIterables() {}

  /**
   * Returns {@code true} if {@code elements} is a sorted collection using an ordering equivalent to
   * {@code alluxio.shaded.client.com.arator}.
   */
  public static boolean hasSameComparator(Comparator<?> alluxio.shaded.client.com.arator, Iterable<?> elements) {
    checkNotNull(alluxio.shaded.client.com.arator);
    checkNotNull(elements);
    Comparator<?> alluxio.shaded.client.com.arator2;
    if (elements instanceof SortedSet) {
      alluxio.shaded.client.com.arator2 = alluxio.shaded.client.com.arator((SortedSet<?>) elements);
    } else if (elements instanceof SortedIterable) {
      alluxio.shaded.client.com.arator2 = ((SortedIterable<?>) elements).alluxio.shaded.client.com.arator();
    } else {
      return false;
    }
    return alluxio.shaded.client.com.arator.equals(alluxio.shaded.client.com.arator2);
  }

  @SuppressWarnings("unchecked")
  // if sortedSet.alluxio.shaded.client.com.arator() is null, the set must be naturally ordered
  public static <E extends @Nullable Object> Comparator<? super E> alluxio.shaded.client.com.arator(
      SortedSet<E> sortedSet) {
    Comparator<? super E> result = sortedSet.alluxio.shaded.client.com.arator();
    if (result == null) {
      result = (Comparator<? super E>) Ordering.natural();
    }
    return result;
  }
}
