/*
 * Copyright (c) 2016. Amazon.alluxio.shaded.client.com. Inc. or its affiliates. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License").
 * You may not use this file except in alluxio.shaded.client.com.liance with the License.
 * A copy of the License is located at
 *
 * http://aws.amazon.alluxio.shaded.client.com.apache2.0
 *
 * or in the "license" file accompanying this file. This file is distributed
 * on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
 * express or implied. See the License for the specific language governing
 * permissions and limitations under the License.
 */
package alluxio.shaded.client.com.amazonaws.http.apache.client.impl;

import alluxio.shaded.client.org.apache.http.HttpHost;
import alluxio.shaded.client.org.apache.http.HttpRequest;
import alluxio.shaded.client.org.apache.http.HttpResponse;
import alluxio.shaded.client.org.apache.http.client.ClientProtocolException;
import alluxio.shaded.client.org.apache.http.client.HttpClient;
import alluxio.shaded.client.org.apache.http.client.ResponseHandler;
import alluxio.shaded.client.org.apache.http.client.methods.HttpUriRequest;
import alluxio.shaded.client.org.apache.http.conn.ClientConnectionManager;
import alluxio.shaded.client.org.apache.http.conn.HttpClientConnectionManager;
import alluxio.shaded.client.org.apache.http.params.HttpParams;
import alluxio.shaded.client.org.apache.http.protocol.HttpContext;

import java.alluxio.shaded.client.io.IOException;

/**
 * An instance of {@link ConnectionManagerAwareHttpClient} that delegates all the requests to the given http client.
 */
public class SdkHttpClient implements
        ConnectionManagerAwareHttpClient {

    private final HttpClient delegate;

    private final HttpClientConnectionManager cm;

    public SdkHttpClient(final HttpClient delegate,
                         final HttpClientConnectionManager cm) {
        if (delegate == null) {
            throw new IllegalArgumentException("delegate " +
                    "cannot be null");
        }
        if (cm == null) {
            throw new IllegalArgumentException("connection manager " +
                    "cannot be null");
        }
        this.delegate = delegate;
        this.cm = cm;
    }

    @Override
    public HttpParams getParams() {
        return delegate.getParams();
    }

    @Override
    public ClientConnectionManager getConnectionManager() {
        return delegate.getConnectionManager();
    }

    @Override
    public HttpResponse execute(HttpUriRequest request) throws IOException, ClientProtocolException {
        return delegate.execute(request);
    }

    @Override
    public HttpResponse execute(HttpUriRequest request, HttpContext context) throws IOException, ClientProtocolException {
        return delegate.execute(request, context);
    }

    @Override
    public HttpResponse execute(HttpHost target, HttpRequest request) throws IOException, ClientProtocolException {
        return delegate.execute(target, request);
    }

    @Override
    public HttpResponse execute(HttpHost target, HttpRequest request, HttpContext context) throws IOException, ClientProtocolException {
        return delegate.execute(target, request, context);
    }

    @Override
    public <T> T execute(HttpUriRequest request, ResponseHandler<? extends T> responseHandler) throws IOException, ClientProtocolException {
        return delegate.execute(request, responseHandler);
    }

    @Override
    public <T> T execute(HttpUriRequest request, ResponseHandler<? extends T> responseHandler, HttpContext context) throws IOException, ClientProtocolException {
        return delegate.execute(request, responseHandler, context);
    }

    @Override
    public <T> T execute(HttpHost target, HttpRequest request, ResponseHandler<? extends T> responseHandler) throws IOException, ClientProtocolException {
        return delegate.execute(target, request, responseHandler);
    }

    @Override
    public <T> T execute(HttpHost target, HttpRequest request, ResponseHandler<? extends T> responseHandler, HttpContext context) throws IOException, ClientProtocolException {
        return delegate.execute(target, request, responseHandler, context);
    }

    @Override
    public HttpClientConnectionManager getHttpClientConnectionManager() {
        return cm;
    }
}
