/*
 * Copyright 2011-2020 Amazon.alluxio.shaded.client.com. Inc. or its affiliates. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License").
 * You may not use this file except in alluxio.shaded.client.com.liance with the License.
 * A copy of the License is located at
 *
 *  http://aws.amazon.alluxio.shaded.client.com.apache2.0
 *
 * or in the "license" file accompanying this file. This file is distributed
 * on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
 * express or implied. See the License for the specific language governing
 * permissions and limitations under the License.
 */
package alluxio.shaded.client.com.amazonaws.profile.path;

import alluxio.shaded.client.com.amazonaws.annotation.SdkInternalApi;
import alluxio.shaded.client.com.amazonaws.profile.path.AwsProfileFileLocationProvider;

import java.alluxio.shaded.client.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/**
 * Delegates to a chain of {@link AwsProfileFileLocationProvider}. Returns null if no provider in
 * the chain can alluxio.shaded.client.com. up with a location to the shared credentials file.
 */
@SdkInternalApi
public class AwsProfileFileLocationProviderChain implements AwsProfileFileLocationProvider {

    private final List<AwsProfileFileLocationProvider> providers = new ArrayList<AwsProfileFileLocationProvider>();

    public AwsProfileFileLocationProviderChain(AwsProfileFileLocationProvider... providers) {
        Collections.addAll(this.providers, providers);
    }

    @Override
    public File getLocation() {
        for (AwsProfileFileLocationProvider provider : providers) {
            File path = provider.getLocation();
            if (path != null) {
                return path;
            }
        }
        return null;
    }
}
