/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.file.cache;

import alluxio.client.file.cache.PageId;
import alluxio.client.file.cache.PageInfo;
import alluxio.client.file.cache.PageMetaStore;
import alluxio.client.file.cache.allocator.Allocator;
import alluxio.client.file.cache.allocator.HashAllocator;
import alluxio.client.file.cache.evictor.CacheEvictor;
import alluxio.client.file.cache.store.PageStoreDir;
import alluxio.client.quota.CacheScope;
import alluxio.collections.IndexDefinition;
import alluxio.collections.IndexedSet;
import alluxio.exception.PageNotFoundException;
import alluxio.metrics.MetricKey;
import alluxio.metrics.MetricsSystem;
import alluxio.shaded.client.com.codahale.metrics.Counter;
import alluxio.shaded.client.com.google.common.base.Preconditions;
import alluxio.shaded.client.com.google.common.collect.ImmutableList;
import alluxio.shaded.client.javax.annotation.Nullable;
import alluxio.shaded.client.javax.annotation.concurrent.GuardedBy;
import alluxio.shaded.client.javax.annotation.concurrent.NotThreadSafe;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class DefaultPageMetaStore
implements PageMetaStore {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultPageMetaStore.class);
    private final IndexedSet<PageInfo> mPages = new IndexedSet<PageInfo>(INDEX_PAGE_ID, INDEX_FILE_ID);
    private final ImmutableList<PageStoreDir> mDirs;
    private final AtomicLong mBytes = new AtomicLong(0L);
    protected final ReentrantReadWriteLock mLock = new ReentrantReadWriteLock();
    private final Allocator mAllcator;
    private static final IndexDefinition<PageInfo, PageId> INDEX_PAGE_ID = IndexDefinition.ofUnique(PageInfo::getPageId);
    private static final IndexDefinition<PageInfo, String> INDEX_FILE_ID = IndexDefinition.ofNonUnique(pageInfo -> pageInfo.getPageId().getFileId());

    public DefaultPageMetaStore(List<PageStoreDir> dirs) {
        this(dirs, new HashAllocator(dirs));
    }

    public DefaultPageMetaStore(List<PageStoreDir> dirs, Allocator allocator) {
        this.mDirs = ImmutableList.copyOf((Collection)Objects.requireNonNull(dirs));
        this.mAllcator = Objects.requireNonNull(allocator);
        MetricsSystem.registerGaugeIfAbsent(MetricKey.CLIENT_CACHE_PAGES.getName(), this.mPages::size);
    }

    @Override
    public ReentrantReadWriteLock getLock() {
        return this.mLock;
    }

    @Override
    @GuardedBy(value="getLock()")
    public boolean hasPage(PageId pageId) {
        return this.mPages.contains(INDEX_PAGE_ID, pageId);
    }

    @Override
    @GuardedBy(value="getLock()")
    public void addPage(PageId pageId, PageInfo pageInfo) {
        this.addPageInternal(pageId, pageInfo);
        pageInfo.getLocalCacheDir().putPage(pageInfo);
    }

    private void addPageInternal(PageId pageId, PageInfo pageInfo) {
        Preconditions.checkArgument(pageId.equals(pageInfo.getPageId()), "page id mismatch");
        this.mPages.add(pageInfo);
        this.mBytes.addAndGet(pageInfo.getPageSize());
        Metrics.SPACE_USED.inc(pageInfo.getPageSize());
    }

    @Override
    @GuardedBy(value="getLock()")
    public void addTempPage(PageId pageId, PageInfo pageInfo) {
        this.addPageInternal(pageId, pageInfo);
        pageInfo.getLocalCacheDir().putTempPage(pageInfo);
    }

    @Override
    @GuardedBy(value="getLock().writeLock()")
    public void commitFile(String fileId, String newFileId) throws PageNotFoundException {
        Set<PageInfo> pages = this.mPages.getByField(INDEX_FILE_ID, fileId);
        if (pages.size() == 0) {
            throw new PageNotFoundException(String.format("No Pages found for file %s when committing", fileId));
        }
        for (PageInfo oldPage : pages) {
            PageId newPageId = new PageId(newFileId, oldPage.getPageId().getPageIndex());
            PageInfo newPageInfo = new PageInfo(newPageId, oldPage.getPageSize(), oldPage.getScope(), oldPage.getLocalCacheDir());
            this.mPages.remove(oldPage);
            this.mPages.add(newPageInfo);
        }
    }

    @Override
    public List<PageStoreDir> getStoreDirs() {
        return this.mDirs;
    }

    @Override
    public PageStoreDir allocate(String fileId, long fileLength) {
        return this.mAllcator.allocate(fileId, fileLength);
    }

    @Override
    @GuardedBy(value="getLock()")
    public PageInfo getPageInfo(PageId pageId) throws PageNotFoundException {
        if (!this.mPages.contains(INDEX_PAGE_ID, pageId)) {
            throw new PageNotFoundException(String.format("Page %s could not be found", pageId));
        }
        PageInfo pageInfo = this.mPages.getFirstByField(INDEX_PAGE_ID, pageId);
        pageInfo.getLocalCacheDir().getEvictor().updateOnGet(pageId);
        return pageInfo;
    }

    @Override
    @GuardedBy(value="getLock()")
    public PageInfo removePage(PageId pageId) throws PageNotFoundException {
        if (!this.mPages.contains(INDEX_PAGE_ID, pageId)) {
            throw new PageNotFoundException(String.format("Page %s could not be found", pageId));
        }
        PageInfo pageInfo = this.mPages.getFirstByField(INDEX_PAGE_ID, pageId);
        this.mPages.remove(pageInfo);
        this.mBytes.addAndGet(-pageInfo.getPageSize());
        Metrics.SPACE_USED.dec(pageInfo.getPageSize());
        pageInfo.getLocalCacheDir().deletePage(pageInfo);
        return pageInfo;
    }

    @Override
    public long bytes() {
        return this.mBytes.get();
    }

    @Override
    @GuardedBy(value="getLock()")
    public long numPages() {
        return this.mPages.size();
    }

    @Override
    @GuardedBy(value="getLock()")
    public void reset() {
        this.mBytes.set(0L);
        Metrics.SPACE_USED.dec(Metrics.SPACE_USED.getCount());
        this.mPages.clear();
    }

    @Override
    @Nullable
    @GuardedBy(value="getLock()")
    public PageInfo evict(CacheScope scope, PageStoreDir pageStoreDir) {
        return this.evictInternal(pageStoreDir.getEvictor());
    }

    PageInfo evictInternal(CacheEvictor evictor) {
        PageId victim = evictor.evict();
        if (victim == null) {
            return null;
        }
        PageInfo victimInfo = this.mPages.getFirstByField(INDEX_PAGE_ID, victim);
        if (victimInfo == null) {
            LOG.error("Invalid result returned by evictor: page {} not available", (Object)victim);
            evictor.updateOnDelete(victim);
            return null;
        }
        return victimInfo;
    }

    private static final class Metrics {
        private static final Counter SPACE_USED = MetricsSystem.counter(MetricKey.CLIENT_CACHE_SPACE_USED_COUNT.getName());

        private Metrics() {
        }
    }
}

