/*
 * Decompiled with CFR 0.152.
 */
package alluxio.shaded.client.org.apache.http.impl.conn;

import alluxio.shaded.client.org.apache.http.HttpResponse;
import alluxio.shaded.client.org.apache.http.HttpResponseFactory;
import alluxio.shaded.client.org.apache.http.annotation.Contract;
import alluxio.shaded.client.org.apache.http.annotation.ThreadingBehavior;
import alluxio.shaded.client.org.apache.http.config.MessageConstraints;
import alluxio.shaded.client.org.apache.http.impl.DefaultHttpResponseFactory;
import alluxio.shaded.client.org.apache.http.impl.conn.DefaultHttpResponseParser;
import alluxio.shaded.client.org.apache.http.io.HttpMessageParser;
import alluxio.shaded.client.org.apache.http.io.HttpMessageParserFactory;
import alluxio.shaded.client.org.apache.http.io.SessionInputBuffer;
import alluxio.shaded.client.org.apache.http.message.BasicLineParser;
import alluxio.shaded.client.org.apache.http.message.LineParser;

@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
public class DefaultHttpResponseParserFactory
implements HttpMessageParserFactory<HttpResponse> {
    public static final DefaultHttpResponseParserFactory INSTANCE = new DefaultHttpResponseParserFactory();
    private final LineParser lineParser;
    private final HttpResponseFactory responseFactory;

    public DefaultHttpResponseParserFactory(LineParser lineParser, HttpResponseFactory responseFactory) {
        this.lineParser = lineParser != null ? lineParser : BasicLineParser.INSTANCE;
        this.responseFactory = responseFactory != null ? responseFactory : DefaultHttpResponseFactory.INSTANCE;
    }

    public DefaultHttpResponseParserFactory(HttpResponseFactory responseFactory) {
        this(null, responseFactory);
    }

    public DefaultHttpResponseParserFactory() {
        this(null, null);
    }

    @Override
    public HttpMessageParser<HttpResponse> create(SessionInputBuffer buffer, MessageConstraints constraints) {
        return new DefaultHttpResponseParser(buffer, this.lineParser, this.responseFactory, constraints);
    }
}

