package alluxio.grpc;

import static alluxio.shaded.client.io.grpc.MethodDescriptor.generateFullMethodName;

/**
 * <pre>
 **
 * This interface contains meta master service endpoints for Alluxio standby masters.
 * </pre>
 */
@alluxio.shaded.client.javax.annotation.Generated(
    value = "by gRPC proto alluxio.shaded.client.com.iler (version 1.54.1)",
    alluxio.shaded.client.com.ents = "Source: grpc/job_master.proto")
@alluxio.shaded.client.io.grpc.stub.annotations.GrpcGenerated
public final class JobMasterMasterServiceGrpc {

  private JobMasterMasterServiceGrpc() {}

  public static final String SERVICE_NAME = "alluxio.grpc.job.JobMasterMasterService";

  // Static method descriptors that strictly reflect the proto.
  private static volatile alluxio.shaded.client.io.grpc.MethodDescriptor<alluxio.grpc.GetJobMasterIdPRequest,
      alluxio.grpc.GetJobMasterIdPResponse> getGetMasterIdMethod;

  @alluxio.shaded.client.io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "GetMasterId",
      requestType = alluxio.grpc.GetJobMasterIdPRequest.class,
      responseType = alluxio.grpc.GetJobMasterIdPResponse.class,
      methodType = alluxio.shaded.client.io.grpc.MethodDescriptor.MethodType.UNARY)
  public static alluxio.shaded.client.io.grpc.MethodDescriptor<alluxio.grpc.GetJobMasterIdPRequest,
      alluxio.grpc.GetJobMasterIdPResponse> getGetMasterIdMethod() {
    alluxio.shaded.client.io.grpc.MethodDescriptor<alluxio.grpc.GetJobMasterIdPRequest, alluxio.grpc.GetJobMasterIdPResponse> getGetMasterIdMethod;
    if ((getGetMasterIdMethod = JobMasterMasterServiceGrpc.getGetMasterIdMethod) == null) {
      synchronized (JobMasterMasterServiceGrpc.class) {
        if ((getGetMasterIdMethod = JobMasterMasterServiceGrpc.getGetMasterIdMethod) == null) {
          JobMasterMasterServiceGrpc.getGetMasterIdMethod = getGetMasterIdMethod =
              alluxio.shaded.client.io.grpc.MethodDescriptor.<alluxio.grpc.GetJobMasterIdPRequest, alluxio.grpc.GetJobMasterIdPResponse>newBuilder()
              .setType(alluxio.shaded.client.io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "GetMasterId"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(alluxio.shaded.client.io.grpc.protobuf.ProtoUtils.marshaller(
                  alluxio.grpc.GetJobMasterIdPRequest.getDefaultInstance()))
              .setResponseMarshaller(alluxio.shaded.client.io.grpc.protobuf.ProtoUtils.marshaller(
                  alluxio.grpc.GetJobMasterIdPResponse.getDefaultInstance()))
              .setSchemaDescriptor(new JobMasterMasterServiceMethodDescriptorSupplier("GetMasterId"))
              .build();
        }
      }
    }
    return getGetMasterIdMethod;
  }

  private static volatile alluxio.shaded.client.io.grpc.MethodDescriptor<alluxio.grpc.RegisterJobMasterPRequest,
      alluxio.grpc.RegisterJobMasterPResponse> getRegisterMasterMethod;

  @alluxio.shaded.client.io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "RegisterMaster",
      requestType = alluxio.grpc.RegisterJobMasterPRequest.class,
      responseType = alluxio.grpc.RegisterJobMasterPResponse.class,
      methodType = alluxio.shaded.client.io.grpc.MethodDescriptor.MethodType.UNARY)
  public static alluxio.shaded.client.io.grpc.MethodDescriptor<alluxio.grpc.RegisterJobMasterPRequest,
      alluxio.grpc.RegisterJobMasterPResponse> getRegisterMasterMethod() {
    alluxio.shaded.client.io.grpc.MethodDescriptor<alluxio.grpc.RegisterJobMasterPRequest, alluxio.grpc.RegisterJobMasterPResponse> getRegisterMasterMethod;
    if ((getRegisterMasterMethod = JobMasterMasterServiceGrpc.getRegisterMasterMethod) == null) {
      synchronized (JobMasterMasterServiceGrpc.class) {
        if ((getRegisterMasterMethod = JobMasterMasterServiceGrpc.getRegisterMasterMethod) == null) {
          JobMasterMasterServiceGrpc.getRegisterMasterMethod = getRegisterMasterMethod =
              alluxio.shaded.client.io.grpc.MethodDescriptor.<alluxio.grpc.RegisterJobMasterPRequest, alluxio.grpc.RegisterJobMasterPResponse>newBuilder()
              .setType(alluxio.shaded.client.io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "RegisterMaster"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(alluxio.shaded.client.io.grpc.protobuf.ProtoUtils.marshaller(
                  alluxio.grpc.RegisterJobMasterPRequest.getDefaultInstance()))
              .setResponseMarshaller(alluxio.shaded.client.io.grpc.protobuf.ProtoUtils.marshaller(
                  alluxio.grpc.RegisterJobMasterPResponse.getDefaultInstance()))
              .setSchemaDescriptor(new JobMasterMasterServiceMethodDescriptorSupplier("RegisterMaster"))
              .build();
        }
      }
    }
    return getRegisterMasterMethod;
  }

  private static volatile alluxio.shaded.client.io.grpc.MethodDescriptor<alluxio.grpc.JobMasterHeartbeatPRequest,
      alluxio.grpc.JobMasterHeartbeatPResponse> getMasterHeartbeatMethod;

  @alluxio.shaded.client.io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "MasterHeartbeat",
      requestType = alluxio.grpc.JobMasterHeartbeatPRequest.class,
      responseType = alluxio.grpc.JobMasterHeartbeatPResponse.class,
      methodType = alluxio.shaded.client.io.grpc.MethodDescriptor.MethodType.UNARY)
  public static alluxio.shaded.client.io.grpc.MethodDescriptor<alluxio.grpc.JobMasterHeartbeatPRequest,
      alluxio.grpc.JobMasterHeartbeatPResponse> getMasterHeartbeatMethod() {
    alluxio.shaded.client.io.grpc.MethodDescriptor<alluxio.grpc.JobMasterHeartbeatPRequest, alluxio.grpc.JobMasterHeartbeatPResponse> getMasterHeartbeatMethod;
    if ((getMasterHeartbeatMethod = JobMasterMasterServiceGrpc.getMasterHeartbeatMethod) == null) {
      synchronized (JobMasterMasterServiceGrpc.class) {
        if ((getMasterHeartbeatMethod = JobMasterMasterServiceGrpc.getMasterHeartbeatMethod) == null) {
          JobMasterMasterServiceGrpc.getMasterHeartbeatMethod = getMasterHeartbeatMethod =
              alluxio.shaded.client.io.grpc.MethodDescriptor.<alluxio.grpc.JobMasterHeartbeatPRequest, alluxio.grpc.JobMasterHeartbeatPResponse>newBuilder()
              .setType(alluxio.shaded.client.io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "MasterHeartbeat"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(alluxio.shaded.client.io.grpc.protobuf.ProtoUtils.marshaller(
                  alluxio.grpc.JobMasterHeartbeatPRequest.getDefaultInstance()))
              .setResponseMarshaller(alluxio.shaded.client.io.grpc.protobuf.ProtoUtils.marshaller(
                  alluxio.grpc.JobMasterHeartbeatPResponse.getDefaultInstance()))
              .setSchemaDescriptor(new JobMasterMasterServiceMethodDescriptorSupplier("MasterHeartbeat"))
              .build();
        }
      }
    }
    return getMasterHeartbeatMethod;
  }

  /**
   * Creates a new async stub that supports all call types for the service
   */
  public static JobMasterMasterServiceStub newStub(alluxio.shaded.client.io.grpc.Channel channel) {
    alluxio.shaded.client.io.grpc.stub.AbstractStub.StubFactory<JobMasterMasterServiceStub> factory =
      new alluxio.shaded.client.io.grpc.stub.AbstractStub.StubFactory<JobMasterMasterServiceStub>() {
        @java.lang.Override
        public JobMasterMasterServiceStub newStub(alluxio.shaded.client.io.grpc.Channel channel, alluxio.shaded.client.io.grpc.CallOptions callOptions) {
          return new JobMasterMasterServiceStub(channel, callOptions);
        }
      };
    return JobMasterMasterServiceStub.newStub(factory, channel);
  }

  /**
   * Creates a new blocking-style stub that supports unary and streaming output calls on the service
   */
  public static JobMasterMasterServiceBlockingStub newBlockingStub(
      alluxio.shaded.client.io.grpc.Channel channel) {
    alluxio.shaded.client.io.grpc.stub.AbstractStub.StubFactory<JobMasterMasterServiceBlockingStub> factory =
      new alluxio.shaded.client.io.grpc.stub.AbstractStub.StubFactory<JobMasterMasterServiceBlockingStub>() {
        @java.lang.Override
        public JobMasterMasterServiceBlockingStub newStub(alluxio.shaded.client.io.grpc.Channel channel, alluxio.shaded.client.io.grpc.CallOptions callOptions) {
          return new JobMasterMasterServiceBlockingStub(channel, callOptions);
        }
      };
    return JobMasterMasterServiceBlockingStub.newStub(factory, channel);
  }

  /**
   * Creates a new ListenableFuture-style stub that supports unary calls on the service
   */
  public static JobMasterMasterServiceFutureStub newFutureStub(
      alluxio.shaded.client.io.grpc.Channel channel) {
    alluxio.shaded.client.io.grpc.stub.AbstractStub.StubFactory<JobMasterMasterServiceFutureStub> factory =
      new alluxio.shaded.client.io.grpc.stub.AbstractStub.StubFactory<JobMasterMasterServiceFutureStub>() {
        @java.lang.Override
        public JobMasterMasterServiceFutureStub newStub(alluxio.shaded.client.io.grpc.Channel channel, alluxio.shaded.client.io.grpc.CallOptions callOptions) {
          return new JobMasterMasterServiceFutureStub(channel, callOptions);
        }
      };
    return JobMasterMasterServiceFutureStub.newStub(factory, channel);
  }

  /**
   * <pre>
   **
   * This interface contains meta master service endpoints for Alluxio standby masters.
   * </pre>
   */
  public interface AsyncService {

    /**
     * <pre>
     **
     * Returns a master id for the given master address.
     * </pre>
     */
    default void getMasterId(alluxio.grpc.GetJobMasterIdPRequest request,
        alluxio.shaded.client.io.grpc.stub.StreamObserver<alluxio.grpc.GetJobMasterIdPResponse> responseObserver) {
      alluxio.shaded.client.io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getGetMasterIdMethod(), responseObserver);
    }

    /**
     * <pre>
     **
     * Registers a master.
     * </pre>
     */
    default void registerMaster(alluxio.grpc.RegisterJobMasterPRequest request,
        alluxio.shaded.client.io.grpc.stub.StreamObserver<alluxio.grpc.RegisterJobMasterPResponse> responseObserver) {
      alluxio.shaded.client.io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getRegisterMasterMethod(), responseObserver);
    }

    /**
     * <pre>
     **
     * Heartbeats to indicate the master is lost or not.
     * </pre>
     */
    default void masterHeartbeat(alluxio.grpc.JobMasterHeartbeatPRequest request,
        alluxio.shaded.client.io.grpc.stub.StreamObserver<alluxio.grpc.JobMasterHeartbeatPResponse> responseObserver) {
      alluxio.shaded.client.io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getMasterHeartbeatMethod(), responseObserver);
    }
  }

  /**
   * Base class for the server implementation of the service JobMasterMasterService.
   * <pre>
   **
   * This interface contains meta master service endpoints for Alluxio standby masters.
   * </pre>
   */
  public static abstract class JobMasterMasterServiceImplBase
      implements alluxio.shaded.client.io.grpc.BindableService, AsyncService {

    @java.lang.Override public final alluxio.shaded.client.io.grpc.ServerServiceDefinition bindService() {
      return JobMasterMasterServiceGrpc.bindService(this);
    }
  }

  /**
   * A stub to allow clients to do asynchronous rpc calls to service JobMasterMasterService.
   * <pre>
   **
   * This interface contains meta master service endpoints for Alluxio standby masters.
   * </pre>
   */
  public static final class JobMasterMasterServiceStub
      extends alluxio.shaded.client.io.grpc.stub.AbstractAsyncStub<JobMasterMasterServiceStub> {
    private JobMasterMasterServiceStub(
        alluxio.shaded.client.io.grpc.Channel channel, alluxio.shaded.client.io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected JobMasterMasterServiceStub build(
        alluxio.shaded.client.io.grpc.Channel channel, alluxio.shaded.client.io.grpc.CallOptions callOptions) {
      return new JobMasterMasterServiceStub(channel, callOptions);
    }

    /**
     * <pre>
     **
     * Returns a master id for the given master address.
     * </pre>
     */
    public void getMasterId(alluxio.grpc.GetJobMasterIdPRequest request,
        alluxio.shaded.client.io.grpc.stub.StreamObserver<alluxio.grpc.GetJobMasterIdPResponse> responseObserver) {
      alluxio.shaded.client.io.grpc.stub.ClientCalls.asyncUnaryCall(
          getChannel().newCall(getGetMasterIdMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     **
     * Registers a master.
     * </pre>
     */
    public void registerMaster(alluxio.grpc.RegisterJobMasterPRequest request,
        alluxio.shaded.client.io.grpc.stub.StreamObserver<alluxio.grpc.RegisterJobMasterPResponse> responseObserver) {
      alluxio.shaded.client.io.grpc.stub.ClientCalls.asyncUnaryCall(
          getChannel().newCall(getRegisterMasterMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     **
     * Heartbeats to indicate the master is lost or not.
     * </pre>
     */
    public void masterHeartbeat(alluxio.grpc.JobMasterHeartbeatPRequest request,
        alluxio.shaded.client.io.grpc.stub.StreamObserver<alluxio.grpc.JobMasterHeartbeatPResponse> responseObserver) {
      alluxio.shaded.client.io.grpc.stub.ClientCalls.asyncUnaryCall(
          getChannel().newCall(getMasterHeartbeatMethod(), getCallOptions()), request, responseObserver);
    }
  }

  /**
   * A stub to allow clients to do synchronous rpc calls to service JobMasterMasterService.
   * <pre>
   **
   * This interface contains meta master service endpoints for Alluxio standby masters.
   * </pre>
   */
  public static final class JobMasterMasterServiceBlockingStub
      extends alluxio.shaded.client.io.grpc.stub.AbstractBlockingStub<JobMasterMasterServiceBlockingStub> {
    private JobMasterMasterServiceBlockingStub(
        alluxio.shaded.client.io.grpc.Channel channel, alluxio.shaded.client.io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected JobMasterMasterServiceBlockingStub build(
        alluxio.shaded.client.io.grpc.Channel channel, alluxio.shaded.client.io.grpc.CallOptions callOptions) {
      return new JobMasterMasterServiceBlockingStub(channel, callOptions);
    }

    /**
     * <pre>
     **
     * Returns a master id for the given master address.
     * </pre>
     */
    public alluxio.grpc.GetJobMasterIdPResponse getMasterId(alluxio.grpc.GetJobMasterIdPRequest request) {
      return alluxio.shaded.client.io.grpc.stub.ClientCalls.blockingUnaryCall(
          getChannel(), getGetMasterIdMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     **
     * Registers a master.
     * </pre>
     */
    public alluxio.grpc.RegisterJobMasterPResponse registerMaster(alluxio.grpc.RegisterJobMasterPRequest request) {
      return alluxio.shaded.client.io.grpc.stub.ClientCalls.blockingUnaryCall(
          getChannel(), getRegisterMasterMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     **
     * Heartbeats to indicate the master is lost or not.
     * </pre>
     */
    public alluxio.grpc.JobMasterHeartbeatPResponse masterHeartbeat(alluxio.grpc.JobMasterHeartbeatPRequest request) {
      return alluxio.shaded.client.io.grpc.stub.ClientCalls.blockingUnaryCall(
          getChannel(), getMasterHeartbeatMethod(), getCallOptions(), request);
    }
  }

  /**
   * A stub to allow clients to do ListenableFuture-style rpc calls to service JobMasterMasterService.
   * <pre>
   **
   * This interface contains meta master service endpoints for Alluxio standby masters.
   * </pre>
   */
  public static final class JobMasterMasterServiceFutureStub
      extends alluxio.shaded.client.io.grpc.stub.AbstractFutureStub<JobMasterMasterServiceFutureStub> {
    private JobMasterMasterServiceFutureStub(
        alluxio.shaded.client.io.grpc.Channel channel, alluxio.shaded.client.io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected JobMasterMasterServiceFutureStub build(
        alluxio.shaded.client.io.grpc.Channel channel, alluxio.shaded.client.io.grpc.CallOptions callOptions) {
      return new JobMasterMasterServiceFutureStub(channel, callOptions);
    }

    /**
     * <pre>
     **
     * Returns a master id for the given master address.
     * </pre>
     */
    public alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.util.concurrent.ListenableFuture<alluxio.grpc.GetJobMasterIdPResponse> getMasterId(
        alluxio.grpc.GetJobMasterIdPRequest request) {
      return alluxio.shaded.client.io.grpc.stub.ClientCalls.futureUnaryCall(
          getChannel().newCall(getGetMasterIdMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     **
     * Registers a master.
     * </pre>
     */
    public alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.util.concurrent.ListenableFuture<alluxio.grpc.RegisterJobMasterPResponse> registerMaster(
        alluxio.grpc.RegisterJobMasterPRequest request) {
      return alluxio.shaded.client.io.grpc.stub.ClientCalls.futureUnaryCall(
          getChannel().newCall(getRegisterMasterMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     **
     * Heartbeats to indicate the master is lost or not.
     * </pre>
     */
    public alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.util.concurrent.ListenableFuture<alluxio.grpc.JobMasterHeartbeatPResponse> masterHeartbeat(
        alluxio.grpc.JobMasterHeartbeatPRequest request) {
      return alluxio.shaded.client.io.grpc.stub.ClientCalls.futureUnaryCall(
          getChannel().newCall(getMasterHeartbeatMethod(), getCallOptions()), request);
    }
  }

  private static final int METHODID_GET_MASTER_ID = 0;
  private static final int METHODID_REGISTER_MASTER = 1;
  private static final int METHODID_MASTER_HEARTBEAT = 2;

  private static final class MethodHandlers<Req, Resp> implements
      alluxio.shaded.client.io.grpc.stub.ServerCalls.UnaryMethod<Req, Resp>,
      alluxio.shaded.client.io.grpc.stub.ServerCalls.ServerStreamingMethod<Req, Resp>,
      alluxio.shaded.client.io.grpc.stub.ServerCalls.ClientStreamingMethod<Req, Resp>,
      alluxio.shaded.client.io.grpc.stub.ServerCalls.BidiStreamingMethod<Req, Resp> {
    private final AsyncService serviceImpl;
    private final int methodId;

    MethodHandlers(AsyncService serviceImpl, int methodId) {
      this.serviceImpl = serviceImpl;
      this.methodId = methodId;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("unchecked")
    public void invoke(Req request, alluxio.shaded.client.io.grpc.stub.StreamObserver<Resp> responseObserver) {
      switch (methodId) {
        case METHODID_GET_MASTER_ID:
          serviceImpl.getMasterId((alluxio.grpc.GetJobMasterIdPRequest) request,
              (alluxio.shaded.client.io.grpc.stub.StreamObserver<alluxio.grpc.GetJobMasterIdPResponse>) responseObserver);
          break;
        case METHODID_REGISTER_MASTER:
          serviceImpl.registerMaster((alluxio.grpc.RegisterJobMasterPRequest) request,
              (alluxio.shaded.client.io.grpc.stub.StreamObserver<alluxio.grpc.RegisterJobMasterPResponse>) responseObserver);
          break;
        case METHODID_MASTER_HEARTBEAT:
          serviceImpl.masterHeartbeat((alluxio.grpc.JobMasterHeartbeatPRequest) request,
              (alluxio.shaded.client.io.grpc.stub.StreamObserver<alluxio.grpc.JobMasterHeartbeatPResponse>) responseObserver);
          break;
        default:
          throw new AssertionError();
      }
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("unchecked")
    public alluxio.shaded.client.io.grpc.stub.StreamObserver<Req> invoke(
        alluxio.shaded.client.io.grpc.stub.StreamObserver<Resp> responseObserver) {
      switch (methodId) {
        default:
          throw new AssertionError();
      }
    }
  }

  public static final alluxio.shaded.client.io.grpc.ServerServiceDefinition bindService(AsyncService service) {
    return alluxio.shaded.client.io.grpc.ServerServiceDefinition.builder(getServiceDescriptor())
        .addMethod(
          getGetMasterIdMethod(),
          alluxio.shaded.client.io.grpc.stub.ServerCalls.asyncUnaryCall(
            new MethodHandlers<
              alluxio.grpc.GetJobMasterIdPRequest,
              alluxio.grpc.GetJobMasterIdPResponse>(
                service, METHODID_GET_MASTER_ID)))
        .addMethod(
          getRegisterMasterMethod(),
          alluxio.shaded.client.io.grpc.stub.ServerCalls.asyncUnaryCall(
            new MethodHandlers<
              alluxio.grpc.RegisterJobMasterPRequest,
              alluxio.grpc.RegisterJobMasterPResponse>(
                service, METHODID_REGISTER_MASTER)))
        .addMethod(
          getMasterHeartbeatMethod(),
          alluxio.shaded.client.io.grpc.stub.ServerCalls.asyncUnaryCall(
            new MethodHandlers<
              alluxio.grpc.JobMasterHeartbeatPRequest,
              alluxio.grpc.JobMasterHeartbeatPResponse>(
                service, METHODID_MASTER_HEARTBEAT)))
        .build();
  }

  private static abstract class JobMasterMasterServiceBaseDescriptorSupplier
      implements alluxio.shaded.client.io.grpc.protobuf.ProtoFileDescriptorSupplier, alluxio.shaded.client.io.grpc.protobuf.ProtoServiceDescriptorSupplier {
    JobMasterMasterServiceBaseDescriptorSupplier() {}

    @java.lang.Override
    public alluxio.shaded.client.com.google.protobuf.Descriptors.FileDescriptor getFileDescriptor() {
      return alluxio.grpc.JobMasterProto.getDescriptor();
    }

    @java.lang.Override
    public alluxio.shaded.client.com.google.protobuf.Descriptors.ServiceDescriptor getServiceDescriptor() {
      return getFileDescriptor().findServiceByName("JobMasterMasterService");
    }
  }

  private static final class JobMasterMasterServiceFileDescriptorSupplier
      extends JobMasterMasterServiceBaseDescriptorSupplier {
    JobMasterMasterServiceFileDescriptorSupplier() {}
  }

  private static final class JobMasterMasterServiceMethodDescriptorSupplier
      extends JobMasterMasterServiceBaseDescriptorSupplier
      implements alluxio.shaded.client.io.grpc.protobuf.ProtoMethodDescriptorSupplier {
    private final String methodName;

    JobMasterMasterServiceMethodDescriptorSupplier(String methodName) {
      this.methodName = methodName;
    }

    @java.lang.Override
    public alluxio.shaded.client.com.google.protobuf.Descriptors.MethodDescriptor getMethodDescriptor() {
      return getServiceDescriptor().findMethodByName(methodName);
    }
  }

  private static volatile alluxio.shaded.client.io.grpc.ServiceDescriptor serviceDescriptor;

  public static alluxio.shaded.client.io.grpc.ServiceDescriptor getServiceDescriptor() {
    alluxio.shaded.client.io.grpc.ServiceDescriptor result = serviceDescriptor;
    if (result == null) {
      synchronized (JobMasterMasterServiceGrpc.class) {
        result = serviceDescriptor;
        if (result == null) {
          serviceDescriptor = result = alluxio.shaded.client.io.grpc.ServiceDescriptor.newBuilder(SERVICE_NAME)
              .setSchemaDescriptor(new JobMasterMasterServiceFileDescriptorSupplier())
              .addMethod(getGetMasterIdMethod())
              .addMethod(getRegisterMasterMethod())
              .addMethod(getMasterHeartbeatMethod())
              .build();
        }
      }
    }
    return result;
  }
}
