package alluxio.grpc;

import static alluxio.shaded.client.io.grpc.MethodDescriptor.generateFullMethodName;

/**
 * <pre>
 **
 * This interface contains journal master service endpoints for Alluxio clients.
 * </pre>
 */
@alluxio.shaded.client.javax.annotation.Generated(
    value = "by gRPC proto alluxio.shaded.client.com.iler (version 1.54.1)",
    alluxio.shaded.client.com.ents = "Source: grpc/journal_master.proto")
@alluxio.shaded.client.io.grpc.stub.annotations.GrpcGenerated
public final class JournalMasterClientServiceGrpc {

  private JournalMasterClientServiceGrpc() {}

  public static final String SERVICE_NAME = "alluxio.grpc.journal.JournalMasterClientService";

  // Static method descriptors that strictly reflect the proto.
  private static volatile alluxio.shaded.client.io.grpc.MethodDescriptor<alluxio.grpc.GetQuorumInfoPRequest,
      alluxio.grpc.GetQuorumInfoPResponse> getGetQuorumInfoMethod;

  @alluxio.shaded.client.io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "GetQuorumInfo",
      requestType = alluxio.grpc.GetQuorumInfoPRequest.class,
      responseType = alluxio.grpc.GetQuorumInfoPResponse.class,
      methodType = alluxio.shaded.client.io.grpc.MethodDescriptor.MethodType.UNARY)
  public static alluxio.shaded.client.io.grpc.MethodDescriptor<alluxio.grpc.GetQuorumInfoPRequest,
      alluxio.grpc.GetQuorumInfoPResponse> getGetQuorumInfoMethod() {
    alluxio.shaded.client.io.grpc.MethodDescriptor<alluxio.grpc.GetQuorumInfoPRequest, alluxio.grpc.GetQuorumInfoPResponse> getGetQuorumInfoMethod;
    if ((getGetQuorumInfoMethod = JournalMasterClientServiceGrpc.getGetQuorumInfoMethod) == null) {
      synchronized (JournalMasterClientServiceGrpc.class) {
        if ((getGetQuorumInfoMethod = JournalMasterClientServiceGrpc.getGetQuorumInfoMethod) == null) {
          JournalMasterClientServiceGrpc.getGetQuorumInfoMethod = getGetQuorumInfoMethod =
              alluxio.shaded.client.io.grpc.MethodDescriptor.<alluxio.grpc.GetQuorumInfoPRequest, alluxio.grpc.GetQuorumInfoPResponse>newBuilder()
              .setType(alluxio.shaded.client.io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "GetQuorumInfo"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(alluxio.shaded.client.io.grpc.protobuf.ProtoUtils.marshaller(
                  alluxio.grpc.GetQuorumInfoPRequest.getDefaultInstance()))
              .setResponseMarshaller(alluxio.shaded.client.io.grpc.protobuf.ProtoUtils.marshaller(
                  alluxio.grpc.GetQuorumInfoPResponse.getDefaultInstance()))
              .setSchemaDescriptor(new JournalMasterClientServiceMethodDescriptorSupplier("GetQuorumInfo"))
              .build();
        }
      }
    }
    return getGetQuorumInfoMethod;
  }

  private static volatile alluxio.shaded.client.io.grpc.MethodDescriptor<alluxio.grpc.RemoveQuorumServerPRequest,
      alluxio.grpc.RemoveQuorumServerPResponse> getRemoveQuorumServerMethod;

  @alluxio.shaded.client.io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "RemoveQuorumServer",
      requestType = alluxio.grpc.RemoveQuorumServerPRequest.class,
      responseType = alluxio.grpc.RemoveQuorumServerPResponse.class,
      methodType = alluxio.shaded.client.io.grpc.MethodDescriptor.MethodType.UNARY)
  public static alluxio.shaded.client.io.grpc.MethodDescriptor<alluxio.grpc.RemoveQuorumServerPRequest,
      alluxio.grpc.RemoveQuorumServerPResponse> getRemoveQuorumServerMethod() {
    alluxio.shaded.client.io.grpc.MethodDescriptor<alluxio.grpc.RemoveQuorumServerPRequest, alluxio.grpc.RemoveQuorumServerPResponse> getRemoveQuorumServerMethod;
    if ((getRemoveQuorumServerMethod = JournalMasterClientServiceGrpc.getRemoveQuorumServerMethod) == null) {
      synchronized (JournalMasterClientServiceGrpc.class) {
        if ((getRemoveQuorumServerMethod = JournalMasterClientServiceGrpc.getRemoveQuorumServerMethod) == null) {
          JournalMasterClientServiceGrpc.getRemoveQuorumServerMethod = getRemoveQuorumServerMethod =
              alluxio.shaded.client.io.grpc.MethodDescriptor.<alluxio.grpc.RemoveQuorumServerPRequest, alluxio.grpc.RemoveQuorumServerPResponse>newBuilder()
              .setType(alluxio.shaded.client.io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "RemoveQuorumServer"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(alluxio.shaded.client.io.grpc.protobuf.ProtoUtils.marshaller(
                  alluxio.grpc.RemoveQuorumServerPRequest.getDefaultInstance()))
              .setResponseMarshaller(alluxio.shaded.client.io.grpc.protobuf.ProtoUtils.marshaller(
                  alluxio.grpc.RemoveQuorumServerPResponse.getDefaultInstance()))
              .setSchemaDescriptor(new JournalMasterClientServiceMethodDescriptorSupplier("RemoveQuorumServer"))
              .build();
        }
      }
    }
    return getRemoveQuorumServerMethod;
  }

  private static volatile alluxio.shaded.client.io.grpc.MethodDescriptor<alluxio.grpc.TransferLeadershipPRequest,
      alluxio.grpc.TransferLeadershipPResponse> getTransferLeadershipMethod;

  @alluxio.shaded.client.io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "TransferLeadership",
      requestType = alluxio.grpc.TransferLeadershipPRequest.class,
      responseType = alluxio.grpc.TransferLeadershipPResponse.class,
      methodType = alluxio.shaded.client.io.grpc.MethodDescriptor.MethodType.UNARY)
  public static alluxio.shaded.client.io.grpc.MethodDescriptor<alluxio.grpc.TransferLeadershipPRequest,
      alluxio.grpc.TransferLeadershipPResponse> getTransferLeadershipMethod() {
    alluxio.shaded.client.io.grpc.MethodDescriptor<alluxio.grpc.TransferLeadershipPRequest, alluxio.grpc.TransferLeadershipPResponse> getTransferLeadershipMethod;
    if ((getTransferLeadershipMethod = JournalMasterClientServiceGrpc.getTransferLeadershipMethod) == null) {
      synchronized (JournalMasterClientServiceGrpc.class) {
        if ((getTransferLeadershipMethod = JournalMasterClientServiceGrpc.getTransferLeadershipMethod) == null) {
          JournalMasterClientServiceGrpc.getTransferLeadershipMethod = getTransferLeadershipMethod =
              alluxio.shaded.client.io.grpc.MethodDescriptor.<alluxio.grpc.TransferLeadershipPRequest, alluxio.grpc.TransferLeadershipPResponse>newBuilder()
              .setType(alluxio.shaded.client.io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "TransferLeadership"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(alluxio.shaded.client.io.grpc.protobuf.ProtoUtils.marshaller(
                  alluxio.grpc.TransferLeadershipPRequest.getDefaultInstance()))
              .setResponseMarshaller(alluxio.shaded.client.io.grpc.protobuf.ProtoUtils.marshaller(
                  alluxio.grpc.TransferLeadershipPResponse.getDefaultInstance()))
              .setSchemaDescriptor(new JournalMasterClientServiceMethodDescriptorSupplier("TransferLeadership"))
              .build();
        }
      }
    }
    return getTransferLeadershipMethod;
  }

  private static volatile alluxio.shaded.client.io.grpc.MethodDescriptor<alluxio.grpc.ResetPrioritiesPRequest,
      alluxio.grpc.ResetPrioritiesPResponse> getResetPrioritiesMethod;

  @alluxio.shaded.client.io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "ResetPriorities",
      requestType = alluxio.grpc.ResetPrioritiesPRequest.class,
      responseType = alluxio.grpc.ResetPrioritiesPResponse.class,
      methodType = alluxio.shaded.client.io.grpc.MethodDescriptor.MethodType.UNARY)
  public static alluxio.shaded.client.io.grpc.MethodDescriptor<alluxio.grpc.ResetPrioritiesPRequest,
      alluxio.grpc.ResetPrioritiesPResponse> getResetPrioritiesMethod() {
    alluxio.shaded.client.io.grpc.MethodDescriptor<alluxio.grpc.ResetPrioritiesPRequest, alluxio.grpc.ResetPrioritiesPResponse> getResetPrioritiesMethod;
    if ((getResetPrioritiesMethod = JournalMasterClientServiceGrpc.getResetPrioritiesMethod) == null) {
      synchronized (JournalMasterClientServiceGrpc.class) {
        if ((getResetPrioritiesMethod = JournalMasterClientServiceGrpc.getResetPrioritiesMethod) == null) {
          JournalMasterClientServiceGrpc.getResetPrioritiesMethod = getResetPrioritiesMethod =
              alluxio.shaded.client.io.grpc.MethodDescriptor.<alluxio.grpc.ResetPrioritiesPRequest, alluxio.grpc.ResetPrioritiesPResponse>newBuilder()
              .setType(alluxio.shaded.client.io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "ResetPriorities"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(alluxio.shaded.client.io.grpc.protobuf.ProtoUtils.marshaller(
                  alluxio.grpc.ResetPrioritiesPRequest.getDefaultInstance()))
              .setResponseMarshaller(alluxio.shaded.client.io.grpc.protobuf.ProtoUtils.marshaller(
                  alluxio.grpc.ResetPrioritiesPResponse.getDefaultInstance()))
              .setSchemaDescriptor(new JournalMasterClientServiceMethodDescriptorSupplier("ResetPriorities"))
              .build();
        }
      }
    }
    return getResetPrioritiesMethod;
  }

  private static volatile alluxio.shaded.client.io.grpc.MethodDescriptor<alluxio.grpc.GetTransferLeaderMessagePRequest,
      alluxio.grpc.GetTransferLeaderMessagePResponse> getGetTransferLeaderMessageMethod;

  @alluxio.shaded.client.io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "GetTransferLeaderMessage",
      requestType = alluxio.grpc.GetTransferLeaderMessagePRequest.class,
      responseType = alluxio.grpc.GetTransferLeaderMessagePResponse.class,
      methodType = alluxio.shaded.client.io.grpc.MethodDescriptor.MethodType.UNARY)
  public static alluxio.shaded.client.io.grpc.MethodDescriptor<alluxio.grpc.GetTransferLeaderMessagePRequest,
      alluxio.grpc.GetTransferLeaderMessagePResponse> getGetTransferLeaderMessageMethod() {
    alluxio.shaded.client.io.grpc.MethodDescriptor<alluxio.grpc.GetTransferLeaderMessagePRequest, alluxio.grpc.GetTransferLeaderMessagePResponse> getGetTransferLeaderMessageMethod;
    if ((getGetTransferLeaderMessageMethod = JournalMasterClientServiceGrpc.getGetTransferLeaderMessageMethod) == null) {
      synchronized (JournalMasterClientServiceGrpc.class) {
        if ((getGetTransferLeaderMessageMethod = JournalMasterClientServiceGrpc.getGetTransferLeaderMessageMethod) == null) {
          JournalMasterClientServiceGrpc.getGetTransferLeaderMessageMethod = getGetTransferLeaderMessageMethod =
              alluxio.shaded.client.io.grpc.MethodDescriptor.<alluxio.grpc.GetTransferLeaderMessagePRequest, alluxio.grpc.GetTransferLeaderMessagePResponse>newBuilder()
              .setType(alluxio.shaded.client.io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "GetTransferLeaderMessage"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(alluxio.shaded.client.io.grpc.protobuf.ProtoUtils.marshaller(
                  alluxio.grpc.GetTransferLeaderMessagePRequest.getDefaultInstance()))
              .setResponseMarshaller(alluxio.shaded.client.io.grpc.protobuf.ProtoUtils.marshaller(
                  alluxio.grpc.GetTransferLeaderMessagePResponse.getDefaultInstance()))
              .setSchemaDescriptor(new JournalMasterClientServiceMethodDescriptorSupplier("GetTransferLeaderMessage"))
              .build();
        }
      }
    }
    return getGetTransferLeaderMessageMethod;
  }

  private static volatile alluxio.shaded.client.io.grpc.MethodDescriptor<alluxio.grpc.GetNodeStatePRequest,
      alluxio.grpc.GetNodeStatePResponse> getGetNodeStateMethod;

  @alluxio.shaded.client.io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "GetNodeState",
      requestType = alluxio.grpc.GetNodeStatePRequest.class,
      responseType = alluxio.grpc.GetNodeStatePResponse.class,
      methodType = alluxio.shaded.client.io.grpc.MethodDescriptor.MethodType.UNARY)
  public static alluxio.shaded.client.io.grpc.MethodDescriptor<alluxio.grpc.GetNodeStatePRequest,
      alluxio.grpc.GetNodeStatePResponse> getGetNodeStateMethod() {
    alluxio.shaded.client.io.grpc.MethodDescriptor<alluxio.grpc.GetNodeStatePRequest, alluxio.grpc.GetNodeStatePResponse> getGetNodeStateMethod;
    if ((getGetNodeStateMethod = JournalMasterClientServiceGrpc.getGetNodeStateMethod) == null) {
      synchronized (JournalMasterClientServiceGrpc.class) {
        if ((getGetNodeStateMethod = JournalMasterClientServiceGrpc.getGetNodeStateMethod) == null) {
          JournalMasterClientServiceGrpc.getGetNodeStateMethod = getGetNodeStateMethod =
              alluxio.shaded.client.io.grpc.MethodDescriptor.<alluxio.grpc.GetNodeStatePRequest, alluxio.grpc.GetNodeStatePResponse>newBuilder()
              .setType(alluxio.shaded.client.io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "GetNodeState"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(alluxio.shaded.client.io.grpc.protobuf.ProtoUtils.marshaller(
                  alluxio.grpc.GetNodeStatePRequest.getDefaultInstance()))
              .setResponseMarshaller(alluxio.shaded.client.io.grpc.protobuf.ProtoUtils.marshaller(
                  alluxio.grpc.GetNodeStatePResponse.getDefaultInstance()))
              .setSchemaDescriptor(new JournalMasterClientServiceMethodDescriptorSupplier("GetNodeState"))
              .build();
        }
      }
    }
    return getGetNodeStateMethod;
  }

  /**
   * Creates a new async stub that supports all call types for the service
   */
  public static JournalMasterClientServiceStub newStub(alluxio.shaded.client.io.grpc.Channel channel) {
    alluxio.shaded.client.io.grpc.stub.AbstractStub.StubFactory<JournalMasterClientServiceStub> factory =
      new alluxio.shaded.client.io.grpc.stub.AbstractStub.StubFactory<JournalMasterClientServiceStub>() {
        @java.lang.Override
        public JournalMasterClientServiceStub newStub(alluxio.shaded.client.io.grpc.Channel channel, alluxio.shaded.client.io.grpc.CallOptions callOptions) {
          return new JournalMasterClientServiceStub(channel, callOptions);
        }
      };
    return JournalMasterClientServiceStub.newStub(factory, channel);
  }

  /**
   * Creates a new blocking-style stub that supports unary and streaming output calls on the service
   */
  public static JournalMasterClientServiceBlockingStub newBlockingStub(
      alluxio.shaded.client.io.grpc.Channel channel) {
    alluxio.shaded.client.io.grpc.stub.AbstractStub.StubFactory<JournalMasterClientServiceBlockingStub> factory =
      new alluxio.shaded.client.io.grpc.stub.AbstractStub.StubFactory<JournalMasterClientServiceBlockingStub>() {
        @java.lang.Override
        public JournalMasterClientServiceBlockingStub newStub(alluxio.shaded.client.io.grpc.Channel channel, alluxio.shaded.client.io.grpc.CallOptions callOptions) {
          return new JournalMasterClientServiceBlockingStub(channel, callOptions);
        }
      };
    return JournalMasterClientServiceBlockingStub.newStub(factory, channel);
  }

  /**
   * Creates a new ListenableFuture-style stub that supports unary calls on the service
   */
  public static JournalMasterClientServiceFutureStub newFutureStub(
      alluxio.shaded.client.io.grpc.Channel channel) {
    alluxio.shaded.client.io.grpc.stub.AbstractStub.StubFactory<JournalMasterClientServiceFutureStub> factory =
      new alluxio.shaded.client.io.grpc.stub.AbstractStub.StubFactory<JournalMasterClientServiceFutureStub>() {
        @java.lang.Override
        public JournalMasterClientServiceFutureStub newStub(alluxio.shaded.client.io.grpc.Channel channel, alluxio.shaded.client.io.grpc.CallOptions callOptions) {
          return new JournalMasterClientServiceFutureStub(channel, callOptions);
        }
      };
    return JournalMasterClientServiceFutureStub.newStub(factory, channel);
  }

  /**
   * <pre>
   **
   * This interface contains journal master service endpoints for Alluxio clients.
   * </pre>
   */
  public interface AsyncService {

    /**
     * <pre>
     **
     * Gets list of server states in an embedded journal quorum.
     * </pre>
     */
    default void getQuorumInfo(alluxio.grpc.GetQuorumInfoPRequest request,
        alluxio.shaded.client.io.grpc.stub.StreamObserver<alluxio.grpc.GetQuorumInfoPResponse> responseObserver) {
      alluxio.shaded.client.io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getGetQuorumInfoMethod(), responseObserver);
    }

    /**
     * <pre>
     **
     * Removes a server from embedded journal quorum.
     * </pre>
     */
    default void removeQuorumServer(alluxio.grpc.RemoveQuorumServerPRequest request,
        alluxio.shaded.client.io.grpc.stub.StreamObserver<alluxio.grpc.RemoveQuorumServerPResponse> responseObserver) {
      alluxio.shaded.client.io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getRemoveQuorumServerMethod(), responseObserver);
    }

    /**
     * <pre>
     **
     * Transfers the leadership from the current leader to another designated leader.
     * </pre>
     */
    default void transferLeadership(alluxio.grpc.TransferLeadershipPRequest request,
        alluxio.shaded.client.io.grpc.stub.StreamObserver<alluxio.grpc.TransferLeadershipPResponse> responseObserver) {
      alluxio.shaded.client.io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getTransferLeadershipMethod(), responseObserver);
    }

    /**
     * <pre>
     **
     * Reset all the RaftPeer priorities.
     * </pre>
     */
    default void resetPriorities(alluxio.grpc.ResetPrioritiesPRequest request,
        alluxio.shaded.client.io.grpc.stub.StreamObserver<alluxio.grpc.ResetPrioritiesPResponse> responseObserver) {
      alluxio.shaded.client.io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getResetPrioritiesMethod(), responseObserver);
    }

    /**
     * <pre>
     **
     * Gets exception message throwing when transfer leader.
     * </pre>
     */
    default void getTransferLeaderMessage(alluxio.grpc.GetTransferLeaderMessagePRequest request,
        alluxio.shaded.client.io.grpc.stub.StreamObserver<alluxio.grpc.GetTransferLeaderMessagePResponse> responseObserver) {
      alluxio.shaded.client.io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getGetTransferLeaderMessageMethod(), responseObserver);
    }

    /**
     * <pre>
     **
     * Gets the state of the current node and returns whether it is primary or standby.
     * </pre>
     */
    default void getNodeState(alluxio.grpc.GetNodeStatePRequest request,
        alluxio.shaded.client.io.grpc.stub.StreamObserver<alluxio.grpc.GetNodeStatePResponse> responseObserver) {
      alluxio.shaded.client.io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getGetNodeStateMethod(), responseObserver);
    }
  }

  /**
   * Base class for the server implementation of the service JournalMasterClientService.
   * <pre>
   **
   * This interface contains journal master service endpoints for Alluxio clients.
   * </pre>
   */
  public static abstract class JournalMasterClientServiceImplBase
      implements alluxio.shaded.client.io.grpc.BindableService, AsyncService {

    @java.lang.Override public final alluxio.shaded.client.io.grpc.ServerServiceDefinition bindService() {
      return JournalMasterClientServiceGrpc.bindService(this);
    }
  }

  /**
   * A stub to allow clients to do asynchronous rpc calls to service JournalMasterClientService.
   * <pre>
   **
   * This interface contains journal master service endpoints for Alluxio clients.
   * </pre>
   */
  public static final class JournalMasterClientServiceStub
      extends alluxio.shaded.client.io.grpc.stub.AbstractAsyncStub<JournalMasterClientServiceStub> {
    private JournalMasterClientServiceStub(
        alluxio.shaded.client.io.grpc.Channel channel, alluxio.shaded.client.io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected JournalMasterClientServiceStub build(
        alluxio.shaded.client.io.grpc.Channel channel, alluxio.shaded.client.io.grpc.CallOptions callOptions) {
      return new JournalMasterClientServiceStub(channel, callOptions);
    }

    /**
     * <pre>
     **
     * Gets list of server states in an embedded journal quorum.
     * </pre>
     */
    public void getQuorumInfo(alluxio.grpc.GetQuorumInfoPRequest request,
        alluxio.shaded.client.io.grpc.stub.StreamObserver<alluxio.grpc.GetQuorumInfoPResponse> responseObserver) {
      alluxio.shaded.client.io.grpc.stub.ClientCalls.asyncUnaryCall(
          getChannel().newCall(getGetQuorumInfoMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     **
     * Removes a server from embedded journal quorum.
     * </pre>
     */
    public void removeQuorumServer(alluxio.grpc.RemoveQuorumServerPRequest request,
        alluxio.shaded.client.io.grpc.stub.StreamObserver<alluxio.grpc.RemoveQuorumServerPResponse> responseObserver) {
      alluxio.shaded.client.io.grpc.stub.ClientCalls.asyncUnaryCall(
          getChannel().newCall(getRemoveQuorumServerMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     **
     * Transfers the leadership from the current leader to another designated leader.
     * </pre>
     */
    public void transferLeadership(alluxio.grpc.TransferLeadershipPRequest request,
        alluxio.shaded.client.io.grpc.stub.StreamObserver<alluxio.grpc.TransferLeadershipPResponse> responseObserver) {
      alluxio.shaded.client.io.grpc.stub.ClientCalls.asyncUnaryCall(
          getChannel().newCall(getTransferLeadershipMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     **
     * Reset all the RaftPeer priorities.
     * </pre>
     */
    public void resetPriorities(alluxio.grpc.ResetPrioritiesPRequest request,
        alluxio.shaded.client.io.grpc.stub.StreamObserver<alluxio.grpc.ResetPrioritiesPResponse> responseObserver) {
      alluxio.shaded.client.io.grpc.stub.ClientCalls.asyncUnaryCall(
          getChannel().newCall(getResetPrioritiesMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     **
     * Gets exception message throwing when transfer leader.
     * </pre>
     */
    public void getTransferLeaderMessage(alluxio.grpc.GetTransferLeaderMessagePRequest request,
        alluxio.shaded.client.io.grpc.stub.StreamObserver<alluxio.grpc.GetTransferLeaderMessagePResponse> responseObserver) {
      alluxio.shaded.client.io.grpc.stub.ClientCalls.asyncUnaryCall(
          getChannel().newCall(getGetTransferLeaderMessageMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     **
     * Gets the state of the current node and returns whether it is primary or standby.
     * </pre>
     */
    public void getNodeState(alluxio.grpc.GetNodeStatePRequest request,
        alluxio.shaded.client.io.grpc.stub.StreamObserver<alluxio.grpc.GetNodeStatePResponse> responseObserver) {
      alluxio.shaded.client.io.grpc.stub.ClientCalls.asyncUnaryCall(
          getChannel().newCall(getGetNodeStateMethod(), getCallOptions()), request, responseObserver);
    }
  }

  /**
   * A stub to allow clients to do synchronous rpc calls to service JournalMasterClientService.
   * <pre>
   **
   * This interface contains journal master service endpoints for Alluxio clients.
   * </pre>
   */
  public static final class JournalMasterClientServiceBlockingStub
      extends alluxio.shaded.client.io.grpc.stub.AbstractBlockingStub<JournalMasterClientServiceBlockingStub> {
    private JournalMasterClientServiceBlockingStub(
        alluxio.shaded.client.io.grpc.Channel channel, alluxio.shaded.client.io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected JournalMasterClientServiceBlockingStub build(
        alluxio.shaded.client.io.grpc.Channel channel, alluxio.shaded.client.io.grpc.CallOptions callOptions) {
      return new JournalMasterClientServiceBlockingStub(channel, callOptions);
    }

    /**
     * <pre>
     **
     * Gets list of server states in an embedded journal quorum.
     * </pre>
     */
    public alluxio.grpc.GetQuorumInfoPResponse getQuorumInfo(alluxio.grpc.GetQuorumInfoPRequest request) {
      return alluxio.shaded.client.io.grpc.stub.ClientCalls.blockingUnaryCall(
          getChannel(), getGetQuorumInfoMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     **
     * Removes a server from embedded journal quorum.
     * </pre>
     */
    public alluxio.grpc.RemoveQuorumServerPResponse removeQuorumServer(alluxio.grpc.RemoveQuorumServerPRequest request) {
      return alluxio.shaded.client.io.grpc.stub.ClientCalls.blockingUnaryCall(
          getChannel(), getRemoveQuorumServerMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     **
     * Transfers the leadership from the current leader to another designated leader.
     * </pre>
     */
    public alluxio.grpc.TransferLeadershipPResponse transferLeadership(alluxio.grpc.TransferLeadershipPRequest request) {
      return alluxio.shaded.client.io.grpc.stub.ClientCalls.blockingUnaryCall(
          getChannel(), getTransferLeadershipMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     **
     * Reset all the RaftPeer priorities.
     * </pre>
     */
    public alluxio.grpc.ResetPrioritiesPResponse resetPriorities(alluxio.grpc.ResetPrioritiesPRequest request) {
      return alluxio.shaded.client.io.grpc.stub.ClientCalls.blockingUnaryCall(
          getChannel(), getResetPrioritiesMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     **
     * Gets exception message throwing when transfer leader.
     * </pre>
     */
    public alluxio.grpc.GetTransferLeaderMessagePResponse getTransferLeaderMessage(alluxio.grpc.GetTransferLeaderMessagePRequest request) {
      return alluxio.shaded.client.io.grpc.stub.ClientCalls.blockingUnaryCall(
          getChannel(), getGetTransferLeaderMessageMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     **
     * Gets the state of the current node and returns whether it is primary or standby.
     * </pre>
     */
    public alluxio.grpc.GetNodeStatePResponse getNodeState(alluxio.grpc.GetNodeStatePRequest request) {
      return alluxio.shaded.client.io.grpc.stub.ClientCalls.blockingUnaryCall(
          getChannel(), getGetNodeStateMethod(), getCallOptions(), request);
    }
  }

  /**
   * A stub to allow clients to do ListenableFuture-style rpc calls to service JournalMasterClientService.
   * <pre>
   **
   * This interface contains journal master service endpoints for Alluxio clients.
   * </pre>
   */
  public static final class JournalMasterClientServiceFutureStub
      extends alluxio.shaded.client.io.grpc.stub.AbstractFutureStub<JournalMasterClientServiceFutureStub> {
    private JournalMasterClientServiceFutureStub(
        alluxio.shaded.client.io.grpc.Channel channel, alluxio.shaded.client.io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected JournalMasterClientServiceFutureStub build(
        alluxio.shaded.client.io.grpc.Channel channel, alluxio.shaded.client.io.grpc.CallOptions callOptions) {
      return new JournalMasterClientServiceFutureStub(channel, callOptions);
    }

    /**
     * <pre>
     **
     * Gets list of server states in an embedded journal quorum.
     * </pre>
     */
    public alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.util.concurrent.ListenableFuture<alluxio.grpc.GetQuorumInfoPResponse> getQuorumInfo(
        alluxio.grpc.GetQuorumInfoPRequest request) {
      return alluxio.shaded.client.io.grpc.stub.ClientCalls.futureUnaryCall(
          getChannel().newCall(getGetQuorumInfoMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     **
     * Removes a server from embedded journal quorum.
     * </pre>
     */
    public alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.util.concurrent.ListenableFuture<alluxio.grpc.RemoveQuorumServerPResponse> removeQuorumServer(
        alluxio.grpc.RemoveQuorumServerPRequest request) {
      return alluxio.shaded.client.io.grpc.stub.ClientCalls.futureUnaryCall(
          getChannel().newCall(getRemoveQuorumServerMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     **
     * Transfers the leadership from the current leader to another designated leader.
     * </pre>
     */
    public alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.util.concurrent.ListenableFuture<alluxio.grpc.TransferLeadershipPResponse> transferLeadership(
        alluxio.grpc.TransferLeadershipPRequest request) {
      return alluxio.shaded.client.io.grpc.stub.ClientCalls.futureUnaryCall(
          getChannel().newCall(getTransferLeadershipMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     **
     * Reset all the RaftPeer priorities.
     * </pre>
     */
    public alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.util.concurrent.ListenableFuture<alluxio.grpc.ResetPrioritiesPResponse> resetPriorities(
        alluxio.grpc.ResetPrioritiesPRequest request) {
      return alluxio.shaded.client.io.grpc.stub.ClientCalls.futureUnaryCall(
          getChannel().newCall(getResetPrioritiesMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     **
     * Gets exception message throwing when transfer leader.
     * </pre>
     */
    public alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.util.concurrent.ListenableFuture<alluxio.grpc.GetTransferLeaderMessagePResponse> getTransferLeaderMessage(
        alluxio.grpc.GetTransferLeaderMessagePRequest request) {
      return alluxio.shaded.client.io.grpc.stub.ClientCalls.futureUnaryCall(
          getChannel().newCall(getGetTransferLeaderMessageMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     **
     * Gets the state of the current node and returns whether it is primary or standby.
     * </pre>
     */
    public alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.util.concurrent.ListenableFuture<alluxio.grpc.GetNodeStatePResponse> getNodeState(
        alluxio.grpc.GetNodeStatePRequest request) {
      return alluxio.shaded.client.io.grpc.stub.ClientCalls.futureUnaryCall(
          getChannel().newCall(getGetNodeStateMethod(), getCallOptions()), request);
    }
  }

  private static final int METHODID_GET_QUORUM_INFO = 0;
  private static final int METHODID_REMOVE_QUORUM_SERVER = 1;
  private static final int METHODID_TRANSFER_LEADERSHIP = 2;
  private static final int METHODID_RESET_PRIORITIES = 3;
  private static final int METHODID_GET_TRANSFER_LEADER_MESSAGE = 4;
  private static final int METHODID_GET_NODE_STATE = 5;

  private static final class MethodHandlers<Req, Resp> implements
      alluxio.shaded.client.io.grpc.stub.ServerCalls.UnaryMethod<Req, Resp>,
      alluxio.shaded.client.io.grpc.stub.ServerCalls.ServerStreamingMethod<Req, Resp>,
      alluxio.shaded.client.io.grpc.stub.ServerCalls.ClientStreamingMethod<Req, Resp>,
      alluxio.shaded.client.io.grpc.stub.ServerCalls.BidiStreamingMethod<Req, Resp> {
    private final AsyncService serviceImpl;
    private final int methodId;

    MethodHandlers(AsyncService serviceImpl, int methodId) {
      this.serviceImpl = serviceImpl;
      this.methodId = methodId;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("unchecked")
    public void invoke(Req request, alluxio.shaded.client.io.grpc.stub.StreamObserver<Resp> responseObserver) {
      switch (methodId) {
        case METHODID_GET_QUORUM_INFO:
          serviceImpl.getQuorumInfo((alluxio.grpc.GetQuorumInfoPRequest) request,
              (alluxio.shaded.client.io.grpc.stub.StreamObserver<alluxio.grpc.GetQuorumInfoPResponse>) responseObserver);
          break;
        case METHODID_REMOVE_QUORUM_SERVER:
          serviceImpl.removeQuorumServer((alluxio.grpc.RemoveQuorumServerPRequest) request,
              (alluxio.shaded.client.io.grpc.stub.StreamObserver<alluxio.grpc.RemoveQuorumServerPResponse>) responseObserver);
          break;
        case METHODID_TRANSFER_LEADERSHIP:
          serviceImpl.transferLeadership((alluxio.grpc.TransferLeadershipPRequest) request,
              (alluxio.shaded.client.io.grpc.stub.StreamObserver<alluxio.grpc.TransferLeadershipPResponse>) responseObserver);
          break;
        case METHODID_RESET_PRIORITIES:
          serviceImpl.resetPriorities((alluxio.grpc.ResetPrioritiesPRequest) request,
              (alluxio.shaded.client.io.grpc.stub.StreamObserver<alluxio.grpc.ResetPrioritiesPResponse>) responseObserver);
          break;
        case METHODID_GET_TRANSFER_LEADER_MESSAGE:
          serviceImpl.getTransferLeaderMessage((alluxio.grpc.GetTransferLeaderMessagePRequest) request,
              (alluxio.shaded.client.io.grpc.stub.StreamObserver<alluxio.grpc.GetTransferLeaderMessagePResponse>) responseObserver);
          break;
        case METHODID_GET_NODE_STATE:
          serviceImpl.getNodeState((alluxio.grpc.GetNodeStatePRequest) request,
              (alluxio.shaded.client.io.grpc.stub.StreamObserver<alluxio.grpc.GetNodeStatePResponse>) responseObserver);
          break;
        default:
          throw new AssertionError();
      }
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("unchecked")
    public alluxio.shaded.client.io.grpc.stub.StreamObserver<Req> invoke(
        alluxio.shaded.client.io.grpc.stub.StreamObserver<Resp> responseObserver) {
      switch (methodId) {
        default:
          throw new AssertionError();
      }
    }
  }

  public static final alluxio.shaded.client.io.grpc.ServerServiceDefinition bindService(AsyncService service) {
    return alluxio.shaded.client.io.grpc.ServerServiceDefinition.builder(getServiceDescriptor())
        .addMethod(
          getGetQuorumInfoMethod(),
          alluxio.shaded.client.io.grpc.stub.ServerCalls.asyncUnaryCall(
            new MethodHandlers<
              alluxio.grpc.GetQuorumInfoPRequest,
              alluxio.grpc.GetQuorumInfoPResponse>(
                service, METHODID_GET_QUORUM_INFO)))
        .addMethod(
          getRemoveQuorumServerMethod(),
          alluxio.shaded.client.io.grpc.stub.ServerCalls.asyncUnaryCall(
            new MethodHandlers<
              alluxio.grpc.RemoveQuorumServerPRequest,
              alluxio.grpc.RemoveQuorumServerPResponse>(
                service, METHODID_REMOVE_QUORUM_SERVER)))
        .addMethod(
          getTransferLeadershipMethod(),
          alluxio.shaded.client.io.grpc.stub.ServerCalls.asyncUnaryCall(
            new MethodHandlers<
              alluxio.grpc.TransferLeadershipPRequest,
              alluxio.grpc.TransferLeadershipPResponse>(
                service, METHODID_TRANSFER_LEADERSHIP)))
        .addMethod(
          getResetPrioritiesMethod(),
          alluxio.shaded.client.io.grpc.stub.ServerCalls.asyncUnaryCall(
            new MethodHandlers<
              alluxio.grpc.ResetPrioritiesPRequest,
              alluxio.grpc.ResetPrioritiesPResponse>(
                service, METHODID_RESET_PRIORITIES)))
        .addMethod(
          getGetTransferLeaderMessageMethod(),
          alluxio.shaded.client.io.grpc.stub.ServerCalls.asyncUnaryCall(
            new MethodHandlers<
              alluxio.grpc.GetTransferLeaderMessagePRequest,
              alluxio.grpc.GetTransferLeaderMessagePResponse>(
                service, METHODID_GET_TRANSFER_LEADER_MESSAGE)))
        .addMethod(
          getGetNodeStateMethod(),
          alluxio.shaded.client.io.grpc.stub.ServerCalls.asyncUnaryCall(
            new MethodHandlers<
              alluxio.grpc.GetNodeStatePRequest,
              alluxio.grpc.GetNodeStatePResponse>(
                service, METHODID_GET_NODE_STATE)))
        .build();
  }

  private static abstract class JournalMasterClientServiceBaseDescriptorSupplier
      implements alluxio.shaded.client.io.grpc.protobuf.ProtoFileDescriptorSupplier, alluxio.shaded.client.io.grpc.protobuf.ProtoServiceDescriptorSupplier {
    JournalMasterClientServiceBaseDescriptorSupplier() {}

    @java.lang.Override
    public alluxio.shaded.client.com.google.protobuf.Descriptors.FileDescriptor getFileDescriptor() {
      return alluxio.grpc.JournalMasterProto.getDescriptor();
    }

    @java.lang.Override
    public alluxio.shaded.client.com.google.protobuf.Descriptors.ServiceDescriptor getServiceDescriptor() {
      return getFileDescriptor().findServiceByName("JournalMasterClientService");
    }
  }

  private static final class JournalMasterClientServiceFileDescriptorSupplier
      extends JournalMasterClientServiceBaseDescriptorSupplier {
    JournalMasterClientServiceFileDescriptorSupplier() {}
  }

  private static final class JournalMasterClientServiceMethodDescriptorSupplier
      extends JournalMasterClientServiceBaseDescriptorSupplier
      implements alluxio.shaded.client.io.grpc.protobuf.ProtoMethodDescriptorSupplier {
    private final String methodName;

    JournalMasterClientServiceMethodDescriptorSupplier(String methodName) {
      this.methodName = methodName;
    }

    @java.lang.Override
    public alluxio.shaded.client.com.google.protobuf.Descriptors.MethodDescriptor getMethodDescriptor() {
      return getServiceDescriptor().findMethodByName(methodName);
    }
  }

  private static volatile alluxio.shaded.client.io.grpc.ServiceDescriptor serviceDescriptor;

  public static alluxio.shaded.client.io.grpc.ServiceDescriptor getServiceDescriptor() {
    alluxio.shaded.client.io.grpc.ServiceDescriptor result = serviceDescriptor;
    if (result == null) {
      synchronized (JournalMasterClientServiceGrpc.class) {
        result = serviceDescriptor;
        if (result == null) {
          serviceDescriptor = result = alluxio.shaded.client.io.grpc.ServiceDescriptor.newBuilder(SERVICE_NAME)
              .setSchemaDescriptor(new JournalMasterClientServiceFileDescriptorSupplier())
              .addMethod(getGetQuorumInfoMethod())
              .addMethod(getRemoveQuorumServerMethod())
              .addMethod(getTransferLeadershipMethod())
              .addMethod(getResetPrioritiesMethod())
              .addMethod(getGetTransferLeaderMessageMethod())
              .addMethod(getGetNodeStateMethod())
              .build();
        }
      }
    }
    return result;
  }
}
