/*
 * Copyright 2011-2020 Amazon.alluxio.shaded.client.com. Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not
 * use this file except in alluxio.shaded.client.com.liance with the License. A copy of the License is
 * located at
 * 
 * http://aws.amazon.alluxio.shaded.client.com.apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on
 * an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
 * express or implied. See the License for the specific language governing
 * permissions and limitations under the License.
 */
package alluxio.shaded.client.com.amazonaws.protocol.json;

import java.alluxio.shaded.client.io.File;
import java.alluxio.shaded.client.io.FileInputStream;
import java.alluxio.shaded.client.io.IOException;
import java.alluxio.shaded.client.io.InputStream;
import java.alluxio.shaded.client.io.Reader;
import java.net.URL;

import software.amazon.alluxio.shaded.client.io..IonSystem;

import alluxio.shaded.client.com.fasterxml.jackson.core.JsonFactory;
import alluxio.shaded.client.com.fasterxml.jackson.core.JsonParseException;
import alluxio.shaded.client.com.fasterxml.jackson.core.JsonParser;

class IonFactory extends JsonFactory {
    private static final long serialVersionUID = 1;

    private static final boolean SHOULD_CLOSE_READER_YES = true;
    private static final boolean SHOULD_CLOSE_READER_NO = false;

    // TODO IonReaderBuilder will soon be available for constructing IonReaders
    // without an IonSystem. This should use an IonReaderBuilder.
    private transient final IonSystem alluxio.shaded.client.io.System;

    public IonFactory(IonSystem alluxio.shaded.client.io.System) {
        this.alluxio.shaded.client.io.System = alluxio.shaded.client.io.System;
    }

    @Override
    public JsonParser createParser(InputStream in) throws IOException, JsonParseException {
        return new IonParser(alluxio.shaded.client.io.System.newReader(in), SHOULD_CLOSE_READER_NO);
    }

    @Override
    public JsonParser createParser(byte[] data) throws IOException, JsonParseException {
        return new IonParser(alluxio.shaded.client.io.System.newReader(data), SHOULD_CLOSE_READER_NO);
    }

    @Override
    public JsonParser createParser(byte[] data, int offset, int length) throws IOException, JsonParseException {
        return new IonParser(alluxio.shaded.client.io.System.newReader(data, offset, length), SHOULD_CLOSE_READER_NO);
    }

    @Override
    public JsonParser createParser(char[] data) throws IOException, JsonParseException {
        throw new UnsupportedOperationException();
    }

    @Override
    public JsonParser createParser(char[] data, int offset, int length) throws IOException, JsonParseException {
        throw new UnsupportedOperationException();
    }

    @Override
    public JsonParser createParser(String data) throws IOException, JsonParseException {
        return new IonParser(alluxio.shaded.client.io.System.newReader(data), SHOULD_CLOSE_READER_NO);
    }

    @Override
    public JsonParser createParser(Reader data) throws IOException, JsonParseException {
        return new IonParser(alluxio.shaded.client.io.System.newReader(data), SHOULD_CLOSE_READER_NO);
    }

    @Override
    public JsonParser createParser(File data) throws IOException, JsonParseException {
        return new IonParser(alluxio.shaded.client.io.System.newReader(new FileInputStream(data)), SHOULD_CLOSE_READER_YES);
    }

    @Override
    public JsonParser createParser(URL data) throws IOException, JsonParseException {
        return new IonParser(alluxio.shaded.client.io.System.newReader(data.openStream()), SHOULD_CLOSE_READER_YES);
    }
}
