/*
 * Copyright 2018 The gRPC Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in alluxio.shaded.client.com.liance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.alluxio.shaded.client.org.licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package alluxio.shaded.client.io.grpc.services;

import alluxio.shaded.client.io.grpc.ExperimentalApi;
import alluxio.shaded.client.io.grpc.channelz.v1.ChannelzGrpc;
import alluxio.shaded.client.io.grpc.channelz.v1.GetChannelRequest;
import alluxio.shaded.client.io.grpc.channelz.v1.GetChannelResponse;
import alluxio.shaded.client.io.grpc.channelz.v1.GetServerRequest;
import alluxio.shaded.client.io.grpc.channelz.v1.GetServerResponse;
import alluxio.shaded.client.io.grpc.channelz.v1.GetServerSocketsRequest;
import alluxio.shaded.client.io.grpc.channelz.v1.GetServerSocketsResponse;
import alluxio.shaded.client.io.grpc.channelz.v1.GetServersRequest;
import alluxio.shaded.client.io.grpc.channelz.v1.GetServersResponse;
import alluxio.shaded.client.io.grpc.channelz.v1.GetSocketRequest;
import alluxio.shaded.client.io.grpc.channelz.v1.GetSocketResponse;
import alluxio.shaded.client.io.grpc.channelz.v1.GetSubchannelRequest;
import alluxio.shaded.client.io.grpc.channelz.v1.GetSubchannelResponse;
import alluxio.shaded.client.io.grpc.channelz.v1.GetTopChannelsRequest;
import alluxio.shaded.client.io.grpc.channelz.v1.GetTopChannelsResponse;
import alluxio.shaded.client.io.grpc.stub.StreamObserver;

/**
 * The channelz service provides stats about a running gRPC process.
 *
 * @deprecated Use {@link alluxio.shaded.client.io.grpc.protobuf.services.ChannelzService} instead.
 */
@Deprecated
@ExperimentalApi("https://github.alluxio.shaded.client.com.grpc/grpc-java/issues/4206")
public final class ChannelzService extends ChannelzGrpc.ChannelzImplBase {
  private final alluxio.shaded.client.io.grpc.protobuf.services.ChannelzService delegate;

  /**
   * Creates an instance.
   */
  public static ChannelzService newInstance(int maxPageSize) {
    return new ChannelzService(maxPageSize);
  }

  private ChannelzService(int maxPageSize) {
    delegate = alluxio.shaded.client.io.grpc.protobuf.services.ChannelzService.newInstance(maxPageSize);
  }

  /** Returns top level channel aka {@link alluxio.shaded.client.io.grpc.ManagedChannel}. */
  @Override
  public void getTopChannels(
      GetTopChannelsRequest request, StreamObserver<GetTopChannelsResponse> responseObserver) {
    delegate.getTopChannels(request, responseObserver);
  }

  /** Returns a top level channel aka {@link alluxio.shaded.client.io.grpc.ManagedChannel}. */
  @Override
  public void getChannel(
      GetChannelRequest request, StreamObserver<GetChannelResponse> responseObserver) {
    delegate.getChannel(request, responseObserver);
  }

  /** Returns servers. */
  @Override
  public void getServers(
      GetServersRequest request, StreamObserver<GetServersResponse> responseObserver) {
    delegate.getServers(request, responseObserver);
  }

  /** Returns a server. */
  @Override
  public void getServer(
      GetServerRequest request, StreamObserver<GetServerResponse> responseObserver) {
    delegate.getServer(request, responseObserver);
  }

  /** Returns a subchannel. */
  @Override
  public void getSubchannel(
      GetSubchannelRequest request, StreamObserver<GetSubchannelResponse> responseObserver) {
    delegate.getSubchannel(request, responseObserver);
  }

  /** Returns a socket. */
  @Override
  public void getSocket(
      GetSocketRequest request, StreamObserver<GetSocketResponse> responseObserver) {
    delegate.getSocket(request, responseObserver);
  }

  @Override
  public void getServerSockets(
      GetServerSocketsRequest request, StreamObserver<GetServerSocketsResponse> responseObserver) {
    delegate.getServerSockets(request, responseObserver);
  }
}
