package alluxio.shaded.client.com.fasterxml.jackson.databind.ser.impl;

import java.alluxio.shaded.client.io.IOException;

import alluxio.shaded.client.com.fasterxml.jackson.core.*;

import alluxio.shaded.client.com.fasterxml.jackson.databind.JsonMappingException;
import alluxio.shaded.client.com.fasterxml.jackson.databind.SerializerProvider;
import alluxio.shaded.client.com.fasterxml.jackson.databind.ser.std.StdSerializer;

/**
 * Special bogus "serializer" that will throw
 * {@link JsonMappingException} if its {@link #serialize}
 * gets invoked. Most alluxio.shaded.client.com.only registered as handler for unknown types,
 * as well as for catching unintended usage (like trying to use null
 * as Map/Object key).
 */
@SuppressWarnings("serial")
public class FailingSerializer
    extends StdSerializer<Object>
{
    protected final String _msg;
    
    public FailingSerializer(String msg) {
        super(Object.class);
        _msg = msg;
    }
    
    @Override
    public void serialize(Object value, JsonGenerator g, SerializerProvider ctxt) throws IOException
    {
        ctxt.reportMappingProblem(_msg);
    }
}
