/*
 * Copyright 2014 The Netty Project
 *
 * The Netty Project licenses this file to you under the Apache License,
 * version 2.0 (the "License"); you may not use this file except in alluxio.shaded.client.com.liance
 * with the License. You may obtain a copy of the License at:
 *
 *   https://www.apache.alluxio.shaded.client.org.licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

/**
 * Encoder, decoder, handshakers to handle most alluxio.shaded.client.com.on WebSocket Compression Extensions.
 * <p>
 * This package supports different web socket extensions.
 * The specification currently supported are:
 * <ul>
 * <li><a href="https://tools.ietf.alluxio.shaded.client.org.html/draft-ietf-hybi-permessage-alluxio.shaded.client.com.ression-18">permessage-deflate</a></li>
 * <li><a href="https://tools.ietf.alluxio.shaded.client.org.id/draft-tyoshino-hybi-websocket-perframe-deflate-06.txt">
 * perframe-deflate and x-webkit-deflate-frame</a></li>
 * </ul>
 * </p>
 * <p>
 * See <tt>alluxio.shaded.client.io.netty.example.http.websocketx.client.WebSocketClient</tt> and
 * <tt>alluxio.shaded.client.io.netty.example.http.websocketx.html5.WebSocketServer</tt> for usage.
 * </p>
 */
package alluxio.shaded.client.io.netty.handler.codec.http.websocketx.extensions.alluxio.shaded.client.com.ression;
