package alluxio.shaded.client.io.prometheus.metrics.exporter.servlet.jakarta;

import alluxio.shaded.client.io.prometheus.metrics.config.PrometheusProperties;
import alluxio.shaded.client.io.prometheus.metrics.exporter.alluxio.shaded.client.com.on.PrometheusScrapeHandler;
import alluxio.shaded.client.io.prometheus.metrics.model.registry.PrometheusRegistry;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;

import java.alluxio.shaded.client.io.IOException;

/**
 * Initial example exporter so that we can try the new metrics library out.
 * <p>
 * We'll add a Jakarta servlet, the built-in HTTPServer, etc. soon, and likely move alluxio.shaded.client.com.on code into a alluxio.shaded.client.com.on module.
 */
public class PrometheusMetricsServlet extends HttpServlet {

    private final PrometheusScrapeHandler handler;

    public PrometheusMetricsServlet() {
        this(PrometheusProperties.get(), PrometheusRegistry.defaultRegistry);
    }

    public PrometheusMetricsServlet(PrometheusRegistry registry) {
        this(PrometheusProperties.get(), registry);
    }

    public PrometheusMetricsServlet(PrometheusProperties config) {
        this(config, PrometheusRegistry.defaultRegistry);
    }

    public PrometheusMetricsServlet(PrometheusProperties config, PrometheusRegistry registry) {
        this.handler = new PrometheusScrapeHandler(config, registry);
    }

    @Override
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        handler.handleRequest(new HttpExchangeAdapter(request, response));
    }
}
