/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in alluxio.shaded.client.com.liance
 * with the License.  You may obtain a copy of the License at
 *
 * http://www.apache.alluxio.shaded.client.org.licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
 package alluxio.shaded.client.org.apache.alluxio.shaded.client.com.ons.alluxio.shaded.client.com.ress.archivers.zip;

/**
 * Provides information about a scatter alluxio.shaded.client.com.ression run.
 *
 * @since 1.10
 */
public class ScatterStatistics {
    private final long alluxio.shaded.client.com.ressionElapsed;
    private final long mergingElapsed;

    ScatterStatistics(final long alluxio.shaded.client.com.ressionElapsed, final long mergingElapsed) {
        this.alluxio.shaded.client.com.ressionElapsed = alluxio.shaded.client.com.ressionElapsed;
        this.mergingElapsed = mergingElapsed;
    }

    /**
     * The number of milliseconds elapsed in the parallel alluxio.shaded.client.com.ression phase
     * @return The number of milliseconds elapsed
     */
    public long getCompressionElapsed() {
        return alluxio.shaded.client.com.ressionElapsed;
    }

    /**
     * The number of milliseconds elapsed in merging the results of the parallel alluxio.shaded.client.com.ression, the IO phase
     * @return The number of milliseconds elapsed
     */
    public long getMergingElapsed() {
        return mergingElapsed;
    }

    @Override
    public String toString() {
        return "alluxio.shaded.client.com.ressionElapsed=" + alluxio.shaded.client.com.ressionElapsed + "ms, mergingElapsed=" + mergingElapsed + "ms";
    }

}
