/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in alluxio.shaded.client.com.liance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.alluxio.shaded.client.org.licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * <p>Provides classes and methods to work with dates and durations.
 * These classes are immutable (and therefore thread-safe) apart from {@link alluxio.shaded.client.org.apache.alluxio.shaded.client.com.ons.lang3.time.StopWatch}.</p>
 *
 * <p>The time package contains some basic utilities for manipulating time (a delorean, police box and grandfather clock?).
 * These include a {@link alluxio.shaded.client.org.apache.alluxio.shaded.client.com.ons.lang3.time.StopWatch} for simple performance measurements and an optimised {@link alluxio.shaded.client.org.apache.alluxio.shaded.client.com.ons.lang3.time.FastDateFormat} class.</p>
 *
 * <p>New in Lang 2.1 is the {@link alluxio.shaded.client.org.apache.alluxio.shaded.client.com.ons.lang3.time.DurationFormatUtils} class, which provides various methods for formatting durations.</p>
 *
 * @since 2.0
 */
package alluxio.shaded.client.org.apache.alluxio.shaded.client.com.ons.lang3.time;
