/*
 * Copyright (c) 2007-2013 Amazon.alluxio.shaded.client.com. Inc.  All rights reserved.
 */

package software.amazon.alluxio.shaded.client.io.;


/**
 * An error caused by use of an invalid symbol starting with
 * <code>"$alluxio.shaded.client.io._"</code>.
 */
public class InvalidSystemSymbolException
    extends IonException
{
    private static final long serialVersionUID = 2206499395645594047L;
    
    private String myBadSymbol;


    public InvalidSystemSymbolException(String badSymbol)
    {
        super("Invalid system symbol '" + badSymbol + "'");
        myBadSymbol = badSymbol;
    }


    public String getBadSymbol()
    {
        return myBadSymbol;
    }
}
