/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.block.options;

import alluxio.grpc.GetWorkerReportPOptions;
import alluxio.shaded.client.com.google.common.base.MoreObjects;
import alluxio.shaded.client.com.google.common.base.Objects;
import alluxio.shaded.client.javax.annotation.concurrent.NotThreadSafe;
import java.io.Serializable;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;

@NotThreadSafe
public final class GetWorkerReportOptions
implements Serializable {
    private static final long serialVersionUID = -7604526631057562523L;
    private Set<String> mAddresses;
    private Set<WorkerInfoField> mFieldRange;
    private WorkerRange mWorkerRange;

    public static GetWorkerReportOptions defaults() {
        return new GetWorkerReportOptions();
    }

    private GetWorkerReportOptions() {
        this.mAddresses = new HashSet<String>();
        this.mFieldRange = EnumSet.allOf(WorkerInfoField.class);
        this.mWorkerRange = WorkerRange.ALL;
    }

    public GetWorkerReportOptions(GetWorkerReportPOptions options) {
        this.mAddresses = new HashSet<String>(options.getAddressesList());
        this.mFieldRange = new HashSet<WorkerInfoField>();
        for (alluxio.grpc.WorkerInfoField field : options.getFieldRangesList()) {
            this.mFieldRange.add(WorkerInfoField.fromProto(field));
        }
        this.mWorkerRange = WorkerRange.fromProto(options.getWorkerRange());
    }

    public Set<String> getAddresses() {
        return this.mAddresses;
    }

    public Set<WorkerInfoField> getFieldRange() {
        return this.mFieldRange;
    }

    public WorkerRange getWorkerRange() {
        return this.mWorkerRange;
    }

    public GetWorkerReportOptions setAddresses(Set<String> addresses) {
        this.mAddresses = addresses;
        return this;
    }

    public GetWorkerReportOptions setFieldRange(Set<WorkerInfoField> fieldRange) {
        this.mFieldRange = fieldRange;
        return this;
    }

    public GetWorkerReportOptions setWorkerRange(WorkerRange workerRange) {
        this.mWorkerRange = workerRange;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetWorkerReportOptions)) {
            return false;
        }
        GetWorkerReportOptions that = (GetWorkerReportOptions)o;
        return this.mAddresses.equals(that.mAddresses) && this.mFieldRange.equals(that.mFieldRange) && this.mWorkerRange.equals((Object)that.mWorkerRange);
    }

    public int hashCode() {
        return Objects.hashCode(new Object[]{this.mAddresses, this.mFieldRange, this.mWorkerRange});
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("addresses", this.mAddresses).add("fieldRange", this.mFieldRange).add("workerRange", (Object)this.mWorkerRange).toString();
    }

    public GetWorkerReportPOptions toProto() {
        GetWorkerReportPOptions.Builder optionsBuilder = GetWorkerReportPOptions.newBuilder();
        optionsBuilder.addAllAddresses(this.mAddresses);
        if (this.mFieldRange != null) {
            HashSet<alluxio.grpc.WorkerInfoField> protoFieldRange = new HashSet<alluxio.grpc.WorkerInfoField>();
            for (WorkerInfoField field : this.mFieldRange) {
                protoFieldRange.add(field.toProto());
            }
            optionsBuilder.addAllFieldRanges(protoFieldRange);
        }
        optionsBuilder.setWorkerRange(this.mWorkerRange.toProto());
        return optionsBuilder.build();
    }

    public static enum WorkerInfoField {
        ADDRESS,
        WORKER_CAPACITY_BYTES,
        WORKER_CAPACITY_BYTES_ON_TIERS,
        ID,
        LAST_CONTACT_SEC,
        START_TIME_MS,
        STATE,
        WORKER_USED_BYTES,
        WORKER_USED_BYTES_ON_TIERS,
        BLOCK_COUNT,
        BUILD_VERSION,
        NUM_VCPU;

        public static final Set<WorkerInfoField> ALL;

        public alluxio.grpc.WorkerInfoField toProto() {
            return alluxio.grpc.WorkerInfoField.valueOf(this.name());
        }

        public static WorkerInfoField fromProto(alluxio.grpc.WorkerInfoField fieldRange) {
            return WorkerInfoField.valueOf(fieldRange.name());
        }

        static {
            ALL = EnumSet.allOf(WorkerInfoField.class);
        }
    }

    public static enum WorkerRange {
        ALL,
        LIVE,
        LOST,
        DECOMMISSIONED,
        SPECIFIED;


        public alluxio.grpc.WorkerRange toProto() {
            return alluxio.grpc.WorkerRange.valueOf(this.name());
        }

        public static WorkerRange fromProto(alluxio.grpc.WorkerRange workerRange) {
            return WorkerRange.valueOf(workerRange.name());
        }
    }
}

