/*
 * Decompiled with CFR 0.152.
 */
package alluxio.util.compression;

import alluxio.conf.Configuration;
import alluxio.conf.PropertyKey;
import alluxio.shaded.client.org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import alluxio.shaded.client.org.apache.commons.compress.compressors.gzip.GzipCompressorOutputStream;
import alluxio.shaded.client.org.apache.commons.compress.compressors.gzip.GzipParameters;
import alluxio.util.compression.DirectoryMarshaller;
import alluxio.util.compression.NoCompressionMarshaller;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;

public class GzipMarshaller
implements DirectoryMarshaller {
    private final int mSnapshotCompressionLevel = Configuration.getInt(PropertyKey.MASTER_EMBEDDED_JOURNAL_SNAPSHOT_REPLICATION_COMPRESSION_LEVEL);
    private final NoCompressionMarshaller mMarshaller = new NoCompressionMarshaller();

    @Override
    public long write(Path path, OutputStream outputStream) throws IOException, InterruptedException {
        GzipParameters params = new GzipParameters();
        params.setCompressionLevel(this.mSnapshotCompressionLevel);
        GzipCompressorOutputStream zipStream = new GzipCompressorOutputStream(outputStream, params);
        long bytes = this.mMarshaller.write(path, zipStream);
        zipStream.finish();
        return bytes;
    }

    @Override
    public long read(Path path, InputStream inputStream) throws IOException {
        GzipCompressorInputStream zipStream = new GzipCompressorInputStream(inputStream);
        return this.mMarshaller.read(path, zipStream);
    }
}

