/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.file;

import alluxio.AlluxioURI;
import alluxio.client.ReadType;
import alluxio.client.file.DelegatingFileSystem;
import alluxio.client.file.FileInStream;
import alluxio.client.file.FileSystem;
import alluxio.client.file.FileSystemContext;
import alluxio.client.file.URIStatus;
import alluxio.client.file.dora.DoraCacheClient;
import alluxio.client.file.dora.WorkerLocationPolicy;
import alluxio.conf.PropertyKey;
import alluxio.exception.AlluxioException;
import alluxio.grpc.GetStatusPOptions;
import alluxio.grpc.OpenFilePOptions;
import alluxio.proto.dataserver.Protocol;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DoraCacheFileSystem
extends DelegatingFileSystem {
    private static final Logger LOG = LoggerFactory.getLogger(DoraCacheFileSystem.class);
    public static final int DUMMY_MOUNT_ID = 0;
    private final DoraCacheClient mDoraClient;
    private final boolean mMetadataCacheEnabled;

    public DoraCacheFileSystem(FileSystem fs, FileSystemContext context) {
        super(fs);
        this.mDoraClient = new DoraCacheClient(context, new WorkerLocationPolicy(2000));
        this.mMetadataCacheEnabled = context.getClusterConf().getBoolean(PropertyKey.DORA_CLIENT_METADATA_CACHE_ENABLED);
    }

    @Override
    public URIStatus getStatus(AlluxioURI path, GetStatusPOptions options) throws IOException, AlluxioException {
        if (!this.mMetadataCacheEnabled) {
            return this.mDelegatedFileSystem.getStatus(path, options);
        }
        try {
            return this.mDoraClient.getStatus(path.getPath(), options);
        }
        catch (RuntimeException ex) {
            LOG.debug("Dora client get status error", (Throwable)ex);
            return this.mDelegatedFileSystem.getStatus(path, options);
        }
    }

    @Override
    public FileInStream openFile(AlluxioURI path, OpenFilePOptions options) throws IOException, AlluxioException {
        return this.openFile(this.getStatus(path), options);
    }

    @Override
    public FileInStream openFile(URIStatus status, OpenFilePOptions options) throws IOException, AlluxioException {
        try {
            Protocol.OpenUfsBlockOptions openUfsBlockOptions = Protocol.OpenUfsBlockOptions.newBuilder().setUfsPath(status.getUfsPath()).setOffsetInFile(0L).setBlockSize(status.getLength()).setMaxUfsReadConcurrency(options.getMaxUfsReadConcurrency()).setNoCache(!ReadType.fromProto(options.getReadType()).isCache()).setMountId(0L).build();
            return this.mDoraClient.getInStream(status, openUfsBlockOptions);
        }
        catch (RuntimeException ex) {
            LOG.debug("Dora client open file error", (Throwable)ex);
            return this.mDelegatedFileSystem.openFile(status, options);
        }
    }
}

