/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.file.dora;

import alluxio.client.block.BlockWorkerInfo;
import alluxio.client.block.stream.BlockWorkerClient;
import alluxio.client.block.stream.GrpcDataReader;
import alluxio.client.file.FileSystemContext;
import alluxio.client.file.URIStatus;
import alluxio.client.file.dora.DoraCacheFileInStream;
import alluxio.client.file.dora.WorkerLocationPolicy;
import alluxio.conf.PropertyKey;
import alluxio.grpc.FileInfo;
import alluxio.grpc.GetStatusPOptions;
import alluxio.grpc.GetStatusPRequest;
import alluxio.grpc.GrpcUtils;
import alluxio.grpc.ReadRequest;
import alluxio.proto.dataserver.Protocol;
import alluxio.resource.CloseableResource;
import alluxio.shaded.client.com.google.common.base.Preconditions;
import alluxio.wire.WorkerNetAddress;
import java.io.IOException;
import java.util.List;

public class DoraCacheClient {
    public static final int DUMMY_BLOCK_ID = -1;
    public static final int PREFERRED_WORKER_COUNT = 1;
    private final FileSystemContext mContext;
    private final long mChunkSize;
    private final WorkerLocationPolicy mWorkerLocationPolicy;

    public DoraCacheClient(FileSystemContext context, WorkerLocationPolicy workerLocationPolicy) {
        this.mContext = context;
        this.mWorkerLocationPolicy = workerLocationPolicy;
        this.mChunkSize = this.mContext.getClusterConf().getBytes(PropertyKey.USER_STREAMING_READER_CHUNK_SIZE_BYTES);
    }

    public DoraCacheFileInStream getInStream(URIStatus status, Protocol.OpenUfsBlockOptions ufsOptions) {
        WorkerNetAddress workerNetAddress = this.getWorkerNetAddress(status.getPath());
        ReadRequest.Builder builder = ReadRequest.newBuilder().setBlockId(-1L).setOpenUfsBlockOptions(ufsOptions).setChunkSize(this.mChunkSize);
        GrpcDataReader.Factory grpcReaderFactory = new GrpcDataReader.Factory(this.mContext, workerNetAddress, builder);
        return new DoraCacheFileInStream(grpcReaderFactory, status.getLength());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public URIStatus getStatus(String path, GetStatusPOptions options) {
        try (CloseableResource<BlockWorkerClient> client = this.mContext.acquireBlockWorkerClient(this.getWorkerNetAddress(path));){
            GetStatusPRequest request = GetStatusPRequest.newBuilder().setPath(path).setOptions(options).build();
            FileInfo fileInfo = client.get().getStatus(request).getFileInfo();
            URIStatus uRIStatus = new URIStatus(GrpcUtils.fromProto(fileInfo));
            return uRIStatus;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private WorkerNetAddress getWorkerNetAddress(String path) {
        List<BlockWorkerInfo> workers = null;
        try {
            workers = this.mContext.getCachedWorkers();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        List<BlockWorkerInfo> preferredWorkers = this.mWorkerLocationPolicy.getPreferredWorkers(workers, path, 1);
        Preconditions.checkState(preferredWorkers.size() > 0);
        WorkerNetAddress workerNetAddress = preferredWorkers.get(0).getNetAddress();
        return workerNetAddress;
    }
}

