/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.file.dora;

import alluxio.client.block.stream.DataReader;
import alluxio.client.block.stream.GrpcDataReader;
import alluxio.client.file.FileInStream;
import alluxio.exception.PreconditionMessage;
import alluxio.exception.status.OutOfRangeException;
import alluxio.network.protocol.databuffer.DataBuffer;
import alluxio.shaded.client.com.google.common.base.Preconditions;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Objects;

public class DoraCacheFileInStream
extends FileInStream {
    private final GrpcDataReader.Factory mGrpcReaderFactory;
    private final long mLength;
    private long mPos = 0L;
    private boolean mClosed;
    private DataReader mDataReader;
    private DataBuffer mCurrentChunk;

    public DoraCacheFileInStream(GrpcDataReader.Factory grpcReaderFactory, long length) {
        this.mGrpcReaderFactory = grpcReaderFactory;
        this.mLength = length;
    }

    @Override
    public long remaining() {
        return this.mLength - this.mPos;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        Objects.requireNonNull(b, "Read buffer cannot be null");
        return this.read(ByteBuffer.wrap(b), off, len);
    }

    @Override
    public int read(ByteBuffer byteBuffer, int off, int len) throws IOException {
        Preconditions.checkArgument(off >= 0 && len >= 0 && len + off <= byteBuffer.capacity(), PreconditionMessage.ERR_BUFFER_STATE.toString(), (Object)byteBuffer.capacity(), (Object)off, (Object)len);
        Preconditions.checkState(!this.mClosed, "Cannot do operations on a closed BlockInStream");
        if (len == 0) {
            return 0;
        }
        if (this.mPos == this.mLength) {
            return -1;
        }
        this.readChunk();
        if (this.mCurrentChunk == null) {
            this.closeDataReader();
            if (this.mPos < this.mLength) {
                throw new OutOfRangeException(String.format("Block %s is expected to be %s bytes, but only %s bytes are available in the UFS. Please retry the read and on the next access, Alluxio will sync with the UFS and fetch the updated file content.", this.mLength, this.mPos));
            }
            return -1;
        }
        int toRead = Math.min(len, this.mCurrentChunk.readableBytes());
        byteBuffer.position(off).limit(off + toRead);
        this.mCurrentChunk.readBytes(byteBuffer);
        this.mPos += (long)toRead;
        if (this.mPos == this.mLength) {
            this.closeDataReader();
        }
        return toRead;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int positionedRead(long position, byte[] buffer, int offset, int length) throws IOException {
        if (length == 0) {
            return 0;
        }
        if (position < 0L || position >= this.mLength) {
            return -1;
        }
        int totalBytesRead = 0;
        try (DataReader reader = this.mGrpcReaderFactory.create(position, length);){
            while (totalBytesRead < length) {
                DataBuffer dataBuffer = null;
                try {
                    int bytesRead;
                    dataBuffer = reader.readChunk();
                    if (dataBuffer != null && (bytesRead = Math.min(dataBuffer.readableBytes(), buffer.length - offset)) != 0) {
                        dataBuffer.readBytes(buffer, offset, bytesRead);
                        totalBytesRead += bytesRead;
                        offset += bytesRead;
                        continue;
                    }
                    break;
                }
                finally {
                    if (dataBuffer == null) continue;
                    dataBuffer.release();
                }
            }
        }
        if (totalBytesRead == 0) {
            return -1;
        }
        return totalBytesRead;
    }

    @Override
    public long getPos() throws IOException {
        return this.mPos;
    }

    @Override
    public void seek(long pos) throws IOException {
        Preconditions.checkState(!this.mClosed, "Cannot do operations on a closed BlockInStream");
        Preconditions.checkArgument(pos >= 0L, PreconditionMessage.ERR_SEEK_NEGATIVE.toString(), pos);
        Preconditions.checkArgument(pos <= this.mLength, "Seek position past the end of the read region (block or file).");
        if (pos == this.mPos) {
            return;
        }
        this.closeDataReader();
        this.mPos = pos;
    }

    @Override
    public long skip(long n) throws IOException {
        Preconditions.checkState(!this.mClosed, "Cannot do operations on a closed BlockInStream");
        if (n <= 0L) {
            return 0L;
        }
        long toSkip = Math.min(this.remaining(), n);
        this.seek(this.mPos + toSkip);
        return toSkip;
    }

    @Override
    public void close() throws IOException {
        if (this.mClosed) {
            return;
        }
        try {
            this.closeDataReader();
        }
        finally {
            this.mGrpcReaderFactory.close();
        }
        this.mClosed = true;
    }

    private void readChunk() throws IOException {
        if (this.mDataReader == null) {
            this.mDataReader = this.mGrpcReaderFactory.create(this.mPos, this.mLength - this.mPos);
        }
        if (this.mCurrentChunk != null && this.mCurrentChunk.readableBytes() == 0) {
            this.mCurrentChunk.release();
            this.mCurrentChunk = null;
        }
        if (this.mCurrentChunk == null) {
            this.mCurrentChunk = this.mDataReader.readChunk();
        }
    }

    private void closeDataReader() throws IOException {
        if (this.mCurrentChunk != null) {
            this.mCurrentChunk.release();
            this.mCurrentChunk = null;
        }
        if (this.mDataReader != null) {
            this.mDataReader.close();
        }
        this.mDataReader = null;
    }
}

