/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.file.dora;

import alluxio.client.block.BlockWorkerInfo;
import alluxio.shaded.client.com.google.common.collect.ImmutableList;
import alluxio.shaded.client.com.google.common.collect.ImmutableSet;
import alluxio.shaded.client.com.google.common.hash.HashFunction;
import alluxio.shaded.client.com.google.common.hash.Hashing;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;

public class WorkerLocationPolicy {
    private static final ConsistentHashProvider HASH_PROVIDER = new ConsistentHashProvider();
    private final int mNumVirtualNodes;

    public WorkerLocationPolicy(int numVirtualNodes) {
        this.mNumVirtualNodes = numVirtualNodes;
    }

    public List<BlockWorkerInfo> getPreferredWorkers(List<BlockWorkerInfo> blockWorkerInfos, String fileId, int count) {
        if (blockWorkerInfos.size() == 0) {
            return ImmutableList.of();
        }
        HASH_PROVIDER.refresh(blockWorkerInfos, this.mNumVirtualNodes);
        return HASH_PROVIDER.getMultiple(fileId, count);
    }

    private static class ConsistentHashProvider {
        private static final HashFunction HASH_FUNCTION = Hashing.murmur3_32_fixed();
        private static final int MAX_ATTEMPTS = 100;
        private List<BlockWorkerInfo> mLastWorkerInfos = ImmutableList.of();
        private NavigableMap<Integer, BlockWorkerInfo> mActiveNodesByConsistentHashing;

        private ConsistentHashProvider() {
        }

        public void refresh(List<BlockWorkerInfo> workerInfos, int numVirtualNodes) {
            if (workerInfos != this.mLastWorkerInfos && !ImmutableSet.copyOf(workerInfos).equals(ImmutableSet.copyOf(this.mLastWorkerInfos))) {
                this.build(workerInfos, numVirtualNodes);
            }
        }

        public List<BlockWorkerInfo> getMultiple(String key, int count) {
            HashSet<BlockWorkerInfo> workers = new HashSet<BlockWorkerInfo>();
            int attempts = 0;
            while (workers.size() < count && attempts < 100) {
                workers.add(this.get(key, ++attempts));
            }
            return ImmutableList.copyOf(workers);
        }

        public BlockWorkerInfo get(String key, int index) {
            int hashKey = HASH_FUNCTION.hashString(String.format("%s%d", key, index), StandardCharsets.UTF_8).asInt();
            Map.Entry<Integer, BlockWorkerInfo> entry = this.mActiveNodesByConsistentHashing.ceilingEntry(hashKey);
            if (entry != null) {
                return this.mActiveNodesByConsistentHashing.ceilingEntry(hashKey).getValue();
            }
            return this.mActiveNodesByConsistentHashing.firstEntry().getValue();
        }

        private void build(List<BlockWorkerInfo> workerInfos, int numVirtualNodes) {
            TreeMap<Integer, BlockWorkerInfo> activeNodesByConsistentHashing = new TreeMap<Integer, BlockWorkerInfo>();
            int weight = (int)Math.ceil(1.0 * (double)numVirtualNodes / (double)workerInfos.size());
            for (BlockWorkerInfo workerInfo : workerInfos) {
                for (int i = 0; i < weight; ++i) {
                    activeNodesByConsistentHashing.put(HASH_FUNCTION.hashString(String.format("%s%d", workerInfo.getNetAddress().toString(), i), StandardCharsets.UTF_8).asInt(), workerInfo);
                }
            }
            this.mLastWorkerInfos = workerInfos;
            this.mActiveNodesByConsistentHashing = activeNodesByConsistentHashing;
        }
    }
}

