/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.file.ufs;

import alluxio.AlluxioURI;
import alluxio.client.file.FileInStream;
import alluxio.client.file.FileOutStream;
import alluxio.client.file.FileSystem;
import alluxio.client.file.FileSystemContext;
import alluxio.client.file.ListStatusPartialResult;
import alluxio.client.file.URIStatus;
import alluxio.client.file.options.UfsFileSystemOptions;
import alluxio.client.file.ufs.UfsFileInStream;
import alluxio.client.file.ufs.UfsFileOutStream;
import alluxio.conf.AlluxioConfiguration;
import alluxio.exception.AlluxioException;
import alluxio.exception.runtime.AlluxioRuntimeException;
import alluxio.grpc.CheckAccessPOptions;
import alluxio.grpc.CreateDirectoryPOptions;
import alluxio.grpc.CreateFilePOptions;
import alluxio.grpc.DeletePOptions;
import alluxio.grpc.ErrorType;
import alluxio.grpc.ExistsPOptions;
import alluxio.grpc.FreePOptions;
import alluxio.grpc.GetStatusPOptions;
import alluxio.grpc.ListStatusPOptions;
import alluxio.grpc.ListStatusPartialPOptions;
import alluxio.grpc.MountPOptions;
import alluxio.grpc.OpenFilePOptions;
import alluxio.grpc.RenamePOptions;
import alluxio.grpc.ScheduleAsyncPersistencePOptions;
import alluxio.grpc.SetAclAction;
import alluxio.grpc.SetAclPOptions;
import alluxio.grpc.SetAttributePOptions;
import alluxio.grpc.UnmountPOptions;
import alluxio.resource.CloseableResource;
import alluxio.security.authorization.AclEntry;
import alluxio.security.authorization.Mode;
import alluxio.shaded.client.com.google.common.base.Preconditions;
import alluxio.shaded.client.com.google.common.io.Closer;
import alluxio.shaded.client.com.google.protobuf.Any;
import alluxio.shaded.client.io.grpc.Status;
import alluxio.shaded.client.javax.annotation.concurrent.ThreadSafe;
import alluxio.underfs.UfsFileStatus;
import alluxio.underfs.UfsManager;
import alluxio.underfs.UfsStatus;
import alluxio.underfs.UnderFileSystem;
import alluxio.underfs.options.CreateOptions;
import alluxio.underfs.options.DeleteOptions;
import alluxio.underfs.options.ListOptions;
import alluxio.underfs.options.MkdirsOptions;
import alluxio.underfs.options.OpenOptions;
import alluxio.util.CommonUtils;
import alluxio.util.ModeUtils;
import alluxio.util.io.PathUtils;
import alluxio.wire.BlockLocationInfo;
import alluxio.wire.FileInfo;
import alluxio.wire.MountPointInfo;
import alluxio.wire.SyncPointInfo;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class UfsBaseFileSystem
implements FileSystem {
    private static final Logger LOG = LoggerFactory.getLogger(UfsBaseFileSystem.class);
    private final Closer mCloser = Closer.create();
    protected final FileSystemContext mFsContext;
    protected final CloseableResource<UnderFileSystem> mUfs;
    protected final AlluxioURI mRootUFS;
    protected volatile boolean mClosed = false;

    public UfsBaseFileSystem(FileSystemContext fsContext, UfsFileSystemOptions options) {
        Preconditions.checkNotNull(fsContext);
        Preconditions.checkNotNull(options);
        this.mFsContext = fsContext;
        String ufsAddress = options.getUfsAddress();
        Preconditions.checkArgument(!ufsAddress.isEmpty(), "ufs address should not be empty");
        this.mRootUFS = new AlluxioURI(ufsAddress);
        UfsManager.UfsClient ufsClient = new UfsManager.UfsClient(() -> UnderFileSystem.Factory.create(ufsAddress, this.mFsContext.getClusterConf()), new AlluxioURI(ufsAddress));
        this.mUfs = ufsClient.acquireUfsResource();
        this.mCloser.register(this.mFsContext);
        this.mCloser.register(this.mUfs);
        LOG.debug("Creating file system connecting to ufs address {}", (Object)ufsAddress);
    }

    @Override
    public synchronized void close() throws IOException {
        if (!this.mClosed) {
            this.mClosed = true;
        }
        this.mCloser.close();
    }

    @Override
    public synchronized boolean isClosed() {
        return this.mClosed;
    }

    @Override
    public void checkAccess(AlluxioURI path, CheckAccessPOptions options) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void createDirectory(AlluxioURI path, CreateDirectoryPOptions options) {
        UfsBaseFileSystem.call(() -> {
            MkdirsOptions ufsOptions = MkdirsOptions.defaults(this.mFsContext.getPathConf(path));
            if (options.hasMode()) {
                ufsOptions.setMode(Mode.fromProto(options.getMode()));
            }
            if (options.hasRecursive()) {
                ufsOptions.setCreateParent(options.getRecursive());
            }
            this.mUfs.get().mkdirs(path.getPath(), ufsOptions);
        });
    }

    @Override
    public FileOutStream createFile(AlluxioURI path, CreateFilePOptions options) {
        return UfsBaseFileSystem.callWithReturn(() -> {
            CreateOptions ufsOptions = CreateOptions.defaults(this.mFsContext.getPathConf(path));
            if (options.hasMode()) {
                ufsOptions.setMode(Mode.fromProto(options.getMode()));
            }
            if (options.hasRecursive()) {
                ufsOptions.setCreateParent(options.getRecursive());
            }
            return new UfsFileOutStream(this.mUfs.get().create(path.getPath(), ufsOptions));
        });
    }

    @Override
    public void delete(AlluxioURI path, DeletePOptions options) {
        UfsBaseFileSystem.call(() -> {
            String ufsPath = path.getPath();
            if (this.mUfs.get().isFile(ufsPath)) {
                this.mUfs.get().deleteFile(ufsPath);
                return;
            }
            DeleteOptions ufsOptions = DeleteOptions.defaults();
            if (options.hasRecursive()) {
                ufsOptions.setRecursive(options.getRecursive());
            }
            this.mUfs.get().deleteDirectory(ufsPath, ufsOptions);
        });
    }

    @Override
    public boolean exists(AlluxioURI path, ExistsPOptions options) {
        return Boolean.TRUE.equals(UfsBaseFileSystem.callWithReturn(() -> this.mUfs.get().exists(path.getPath())));
    }

    @Override
    public void free(AlluxioURI path, FreePOptions options) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<BlockLocationInfo> getBlockLocations(AlluxioURI path) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<BlockLocationInfo> getBlockLocations(URIStatus status) {
        throw new UnsupportedOperationException();
    }

    @Override
    public AlluxioConfiguration getConf() {
        return this.mFsContext.getClusterConf();
    }

    @Override
    public URIStatus getStatus(AlluxioURI path) {
        return this.getStatus(path, GetStatusPOptions.getDefaultInstance());
    }

    @Override
    public URIStatus getStatus(AlluxioURI path, GetStatusPOptions options) {
        return UfsBaseFileSystem.callWithReturn(() -> this.transformStatus(this.mUfs.get().getStatus(path.getPath())));
    }

    @Override
    public List<URIStatus> listStatus(AlluxioURI path, ListStatusPOptions options) {
        return UfsBaseFileSystem.callWithReturn(() -> {
            UfsStatus[] ufsStatuses;
            ListOptions ufsOptions = ListOptions.defaults();
            if (options.hasRecursive()) {
                ufsOptions.setRecursive(options.getRecursive());
            }
            if ((ufsStatuses = this.mUfs.get().listStatus(path.getPath(), ufsOptions)) == null || ufsStatuses.length == 0) {
                return Collections.emptyList();
            }
            return Arrays.stream(ufsStatuses).map(this::transformStatus).collect(Collectors.toList());
        });
    }

    @Override
    public void iterateStatus(AlluxioURI path, ListStatusPOptions options, Consumer<? super URIStatus> action) {
        UfsBaseFileSystem.call(() -> {
            UfsStatus[] ufsStatuses;
            ListOptions ufsOptions = ListOptions.defaults();
            if (options.hasRecursive()) {
                ufsOptions.setRecursive(options.getRecursive());
            }
            if ((ufsStatuses = this.mUfs.get().listStatus(path.getPath(), ufsOptions)) == null || ufsStatuses.length == 0) {
                return;
            }
            Arrays.stream(ufsStatuses).map(this::transformStatus).forEach(action);
        });
    }

    @Override
    public ListStatusPartialResult listStatusPartial(AlluxioURI path, ListStatusPartialPOptions options) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void loadMetadata(AlluxioURI path, ListStatusPOptions options) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void mount(AlluxioURI alluxioPath, AlluxioURI ufsPath, MountPOptions options) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateMount(AlluxioURI alluxioPath, MountPOptions options) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Map<String, MountPointInfo> getMountTable(boolean checkUfs) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<SyncPointInfo> getSyncPathList() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void persist(AlluxioURI path, ScheduleAsyncPersistencePOptions options) {
        throw new UnsupportedOperationException();
    }

    @Override
    public FileInStream openFile(AlluxioURI path, OpenFilePOptions options) {
        return this.openFile(this.getStatus(path), options);
    }

    @Override
    public FileInStream openFile(URIStatus status, OpenFilePOptions options) {
        return UfsBaseFileSystem.callWithReturn(() -> new UfsFileInStream(offset -> {
            try {
                return this.mUfs.get().open(status.getPath(), OpenOptions.defaults().setOffset((long)offset));
            }
            catch (IOException e) {
                throw AlluxioRuntimeException.from(e);
            }
        }, status.getLength()));
    }

    @Override
    public void rename(AlluxioURI src, AlluxioURI dst, RenamePOptions options) {
        UfsBaseFileSystem.call(() -> {
            String srcPath = src.getPath();
            String dstPath = dst.getPath();
            boolean renamed = this.mUfs.get().isFile(srcPath) ? this.mUfs.get().renameFile(srcPath, dstPath) : this.mUfs.get().renameDirectory(srcPath, dstPath);
            if (!renamed) {
                throw new AlluxioRuntimeException(Status.FAILED_PRECONDITION, String.format("Failed to rename from %s to %s", srcPath, dstPath), null, ErrorType.External, false, new Any[0]);
            }
        });
    }

    @Override
    public AlluxioURI reverseResolve(AlluxioURI ufsUri) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setAcl(AlluxioURI path, SetAclAction action, List<AclEntry> entries, SetAclPOptions options) {
        UfsBaseFileSystem.call(() -> this.mUfs.get().setAclEntries(path.getPath(), entries));
    }

    @Override
    public void setAttribute(AlluxioURI path, SetAttributePOptions options) {
        UfsBaseFileSystem.call(() -> {
            if (options.hasMode()) {
                this.mUfs.get().setMode(path.getPath(), ModeUtils.protoToShort(options.getMode()));
            }
            if (options.hasOwner() && options.hasGroup()) {
                this.mUfs.get().setOwner(path.getPath(), options.getOwner(), options.getGroup());
            } else if (options.hasOwner()) {
                this.mUfs.get().setOwner(path.getPath(), options.getOwner(), null);
            } else if (options.hasGroup()) {
                this.mUfs.get().setOwner(path.getPath(), null, options.getOwner());
            }
            if (options.hasPinned() || options.hasPersisted() || options.hasRecursive() || options.hasReplicationMax() || options.hasReplicationMin() || options.getXattrCount() != 0) {
                LOG.error("UFS only supports setting mode, owner, and group. Does not support setting {}", (Object)options);
                throw new UnsupportedOperationException(String.format("Cannot set attribute of %s", options));
            }
        });
    }

    @Override
    public void startSync(AlluxioURI path) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void stopSync(AlluxioURI path) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void unmount(AlluxioURI path, UnmountPOptions options) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void needsSync(AlluxioURI path) throws IOException, AlluxioException {
        throw new UnsupportedOperationException();
    }

    private URIStatus transformStatus(UfsStatus ufsStatus) {
        AlluxioURI ufsUri = new AlluxioURI(PathUtils.concatPath((Object)this.mRootUFS, (Object)CommonUtils.stripPrefixIfPresent(ufsStatus.getName(), this.mRootUFS.getPath())));
        FileInfo info = new FileInfo().setName(ufsUri.getName()).setPath(ufsUri.toString()).setFileId(ufsUri.hashCode()).setUfsPath(ufsUri.toString()).setFolder(ufsStatus.isDirectory()).setOwner(ufsStatus.getOwner()).setGroup(ufsStatus.getGroup()).setMode(ufsStatus.getMode()).setCompleted(true);
        if (ufsStatus.getLastModifiedTime() != null) {
            info.setLastModificationTimeMs(info.getLastModificationTimeMs());
        }
        if (ufsStatus.getXAttr() != null) {
            info.setXAttr(ufsStatus.getXAttr());
        }
        if (ufsStatus instanceof UfsFileStatus) {
            UfsFileStatus fileStatus = (UfsFileStatus)ufsStatus;
            info.setLength(fileStatus.getContentLength());
            info.setBlockSizeBytes(fileStatus.getBlockSize());
        } else {
            info.setLength(0L);
        }
        return new URIStatus(info);
    }

    private static void call(UfsCallable callable) {
        try {
            callable.call();
        }
        catch (IOException e) {
            throw AlluxioRuntimeException.from(e);
        }
    }

    private static <T> T callWithReturn(UfsCallableWithReturn<T> callable) {
        try {
            return callable.call();
        }
        catch (IOException e) {
            throw AlluxioRuntimeException.from(e);
        }
    }

    static interface UfsCallableWithReturn<V> {
        public V call() throws IOException;
    }

    static interface UfsCallable {
        public void call() throws IOException;
    }
}

