/*
 * Decompiled with CFR 0.152.
 */
package alluxio.conf.path;

import alluxio.AlluxioURI;
import alluxio.conf.path.PathMatcher;
import alluxio.conf.path.TrieNode;
import alluxio.shaded.client.com.google.common.base.Preconditions;
import alluxio.shaded.client.javax.annotation.concurrent.ThreadSafe;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

@ThreadSafe
public final class PrefixPathMatcher
implements PathMatcher {
    private final TrieNode mTrie = new TrieNode();
    private final Map<TrieNode, String> mPaths = new HashMap<TrieNode, String>();

    public PrefixPathMatcher(Set<String> paths) {
        for (String path : paths) {
            Preconditions.checkArgument(path.startsWith("/"), "Path must start with /");
            TrieNode node = this.mTrie.insert(path);
            this.mPaths.put(node, path);
        }
    }

    @Override
    public Optional<List<String>> match(AlluxioURI path) {
        List nodes = this.mTrie.search(path.getPath());
        if (nodes.isEmpty()) {
            return Optional.empty();
        }
        ArrayList<String> matchedPaths = new ArrayList<String>();
        for (int i = nodes.size() - 1; i >= 0; --i) {
            TrieNode node = nodes.get(i);
            if (!this.mPaths.containsKey(node)) continue;
            matchedPaths.add(this.mPaths.get(node));
        }
        return Optional.of(matchedPaths);
    }
}

