/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.block.policy;

import alluxio.client.block.BlockWorkerInfo;
import alluxio.client.block.policy.BlockLocationPolicy;
import alluxio.client.block.policy.options.GetWorkerOptions;
import alluxio.conf.AlluxioConfiguration;
import alluxio.shaded.client.javax.annotation.concurrent.ThreadSafe;
import alluxio.wire.WorkerNetAddress;
import java.util.Optional;
import java.util.TreeMap;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicLong;

@ThreadSafe
public class CapacityBaseRandomPolicy
implements BlockLocationPolicy {
    public CapacityBaseRandomPolicy(AlluxioConfiguration ignoredConf) {
    }

    @Override
    public Optional<WorkerNetAddress> getWorker(GetWorkerOptions options) {
        Iterable<BlockWorkerInfo> blockWorkerInfos = options.getBlockWorkerInfos();
        TreeMap rangeStartMap = new TreeMap();
        AtomicLong totalCapacity = new AtomicLong(0L);
        blockWorkerInfos.forEach(workerInfo -> {
            if (workerInfo.getCapacityBytes() > 0L) {
                long capacityRangeStart = totalCapacity.getAndAdd(workerInfo.getCapacityBytes());
                rangeStartMap.put(capacityRangeStart, workerInfo);
            }
        });
        if (totalCapacity.get() == 0L) {
            return Optional.empty();
        }
        long randomLong = this.randomInCapacity(totalCapacity.get());
        return Optional.of(((BlockWorkerInfo)rangeStartMap.floorEntry(randomLong).getValue()).getNetAddress());
    }

    protected long randomInCapacity(long totalCapacity) {
        return ThreadLocalRandom.current().nextLong(totalCapacity);
    }
}

