/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.file.cache;

import alluxio.client.file.CacheContext;
import alluxio.client.file.cache.CacheManager;
import alluxio.client.file.cache.CacheUsage;
import alluxio.client.file.cache.PageId;
import alluxio.client.file.cache.ShadowCacheManager;
import alluxio.client.file.cache.store.PageReadTargetBuffer;
import alluxio.client.quota.CacheScope;
import alluxio.conf.AlluxioConfiguration;
import alluxio.metrics.MetricKey;
import alluxio.metrics.MetricsSystem;
import alluxio.shaded.client.com.codahale.metrics.Counter;
import alluxio.shaded.client.com.google.common.annotations.VisibleForTesting;
import alluxio.shaded.client.com.google.common.hash.Funnel;
import alluxio.shaded.client.com.google.common.hash.PrimitiveSink;
import alluxio.shaded.client.javax.annotation.Nonnull;
import java.nio.ByteBuffer;
import java.util.Optional;

public class CacheManagerWithShadowCache
implements CacheManager {
    private final CacheManager mCacheManager;
    private final ShadowCacheManager mShadowCacheManager;
    private long mShadowCachePages = 0L;
    private long mShadowCacheBytes = 0L;

    public CacheManagerWithShadowCache(CacheManager cacheManager, AlluxioConfiguration conf) {
        this.mCacheManager = cacheManager;
        this.mShadowCacheManager = ShadowCacheManager.create(conf);
    }

    @Override
    public boolean put(PageId pageId, ByteBuffer page, CacheContext cacheContext) {
        this.updateShadowCache(pageId, page.remaining(), cacheContext);
        return this.mCacheManager.put(pageId, page, cacheContext);
    }

    @Override
    public int get(PageId pageId, int pageOffset, int bytesToRead, PageReadTargetBuffer target, CacheContext cacheContext) {
        int nread = this.mShadowCacheManager.get(pageId, bytesToRead, this.getCacheScope(cacheContext));
        if (nread > 0) {
            Metrics.SHADOW_CACHE_PAGES_HIT.inc();
            Metrics.SHADOW_CACHE_BYTES_HIT.inc(nread);
        } else {
            this.updateShadowCache(pageId, bytesToRead, cacheContext);
        }
        Metrics.SHADOW_CACHE_PAGES_READ.inc();
        Metrics.SHADOW_CACHE_BYTES_READ.inc(bytesToRead);
        return this.mCacheManager.get(pageId, pageOffset, bytesToRead, target, cacheContext);
    }

    private void updateShadowCache(PageId pageId, int pageLength, CacheContext cacheContext) {
        if (this.mShadowCacheManager.put(pageId, pageLength, this.getCacheScope(cacheContext))) {
            this.updateFalsePositiveRatio();
            this.updateWorkingSetSize();
            if (cacheContext != null) {
                cacheContext.incrementCounter(MetricKey.CLIENT_CACHE_SHADOW_CACHE_BYTES.getName(), CacheContext.StatsUnit.BYTE, pageLength);
            }
        }
    }

    private CacheScope getCacheScope(CacheContext cacheContext) {
        return cacheContext == null ? CacheScope.GLOBAL : cacheContext.getCacheScope();
    }

    private void updateFalsePositiveRatio() {
        int falsePositiveRatio = (int)this.mShadowCacheManager.getFalsePositiveRatio() * 100;
        long oldFalsePositiveRatio = Metrics.SHADOW_CACHE_FALSE_POSITIVE_RATIO.getCount();
        Metrics.SHADOW_CACHE_FALSE_POSITIVE_RATIO.inc((long)falsePositiveRatio - oldFalsePositiveRatio);
    }

    @VisibleForTesting
    public void updateWorkingSetSize() {
        this.mShadowCacheManager.updateWorkingSetSize();
        long oldPages = Metrics.SHADOW_CACHE_PAGES.getCount();
        this.mShadowCachePages = this.mShadowCacheManager.getShadowCachePages();
        Metrics.SHADOW_CACHE_PAGES.inc(this.mShadowCachePages - oldPages);
        long oldBytes = Metrics.SHADOW_CACHE_BYTES.getCount();
        this.mShadowCacheBytes = this.mShadowCacheManager.getShadowCacheBytes();
        Metrics.SHADOW_CACHE_BYTES.inc(this.mShadowCacheBytes - oldBytes);
    }

    @Override
    public boolean delete(PageId pageId) {
        return this.mCacheManager.delete(pageId);
    }

    @VisibleForTesting
    public void stopUpdate() {
        this.mShadowCacheManager.stopUpdate();
    }

    @Override
    public CacheManager.State state() {
        return this.mCacheManager.state();
    }

    @Override
    public boolean append(PageId pageId, int appendAt, byte[] page, CacheContext cacheContext) {
        return this.mCacheManager.append(pageId, appendAt, page, cacheContext);
    }

    @Override
    public void close() throws Exception {
        this.mCacheManager.close();
    }

    @Override
    public Optional<CacheUsage> getUsage() {
        return this.mCacheManager.getUsage();
    }

    public void aging() {
        this.mShadowCacheManager.aging();
    }

    public long getShadowCachePages() {
        return this.mShadowCachePages;
    }

    public long getShadowCacheBytes() {
        return this.mShadowCacheBytes;
    }

    public long getShadowCachePageRead() {
        return this.mShadowCacheManager.getShadowCachePageRead();
    }

    public long getShadowCachePageHit() {
        return this.mShadowCacheManager.getShadowCachePageHit();
    }

    public long getShadowCacheByteRead() {
        return this.mShadowCacheManager.getShadowCacheByteRead();
    }

    public long getShadowCacheByteHit() {
        return this.mShadowCacheManager.getShadowCacheByteHit();
    }

    private static final class Metrics {
        private static final Counter SHADOW_CACHE_BYTES_READ = MetricsSystem.counter(MetricKey.CLIENT_CACHE_SHADOW_CACHE_BYTES_READ.getName());
        private static final Counter SHADOW_CACHE_BYTES_HIT = MetricsSystem.counter(MetricKey.CLIENT_CACHE_SHADOW_CACHE_BYTES_HIT.getName());
        private static final Counter SHADOW_CACHE_PAGES_READ = MetricsSystem.counter(MetricKey.CLIENT_CACHE_SHADOW_CACHE_PAGES_READ.getName());
        private static final Counter SHADOW_CACHE_PAGES_HIT = MetricsSystem.counter(MetricKey.CLIENT_CACHE_SHADOW_CACHE_PAGES_HIT.getName());
        private static final Counter SHADOW_CACHE_PAGES = MetricsSystem.counter(MetricKey.CLIENT_CACHE_SHADOW_CACHE_PAGES.getName());
        private static final Counter SHADOW_CACHE_BYTES = MetricsSystem.counter(MetricKey.CLIENT_CACHE_SHADOW_CACHE_BYTES.getName());
        private static final Counter SHADOW_CACHE_FALSE_POSITIVE_RATIO = MetricsSystem.counter(MetricKey.CLIENT_CACHE_SHADOW_CACHE_FALSE_POSITIVE_RATIO.getName());

        private Metrics() {
        }
    }

    public static enum PageIdFunnel implements Funnel<PageId>
    {
        FUNNEL;


        @Override
        public void funnel(@Nonnull PageId from, PrimitiveSink into) {
            into.putUnencodedChars(from.getFileId()).putLong(from.getPageIndex());
        }
    }
}

