/*
 * Decompiled with CFR 0.152.
 */
package alluxio.file;

import alluxio.Seekable;
import alluxio.shaded.client.com.google.common.base.Preconditions;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;

public class SeekableBufferedInputStream
extends BufferedInputStream
implements Seekable {
    public SeekableBufferedInputStream(InputStream in, int size) {
        super(in, size);
        Preconditions.checkArgument(in instanceof Seekable, "Input stream must implement Seeakble");
    }

    @Override
    public long getPos() throws IOException {
        return ((Seekable)((Object)this.in)).getPos() - (long)(this.count - this.pos);
    }

    @Override
    public long skip(long n) throws IOException {
        if (n <= 0L) {
            return 0L;
        }
        this.seek(this.getPos() + n);
        return n;
    }

    @Override
    public void seek(long newPosition) throws IOException {
        if (newPosition < 0L) {
            return;
        }
        long end = ((Seekable)((Object)this.in)).getPos();
        long start = end - (long)this.count;
        if (start <= newPosition && newPosition < end) {
            this.pos = (int)(newPosition - start);
            return;
        }
        this.pos = 0;
        this.count = 0;
        ((Seekable)((Object)this.in)).seek(newPosition);
    }
}

