/*
 * Decompiled with CFR 0.152.
 */
package alluxio.grpc;

import alluxio.grpc.GrpcNetworkGroup;
import alluxio.grpc.GrpcServerAddress;
import alluxio.shaded.client.com.google.common.base.MoreObjects;
import java.util.Objects;
import java.util.UUID;

public class GrpcChannelKey {
    private final GrpcNetworkGroup mNetworkGroup;
    private final GrpcServerAddress mServerAddress;
    private final UUID mChannelId = UUID.randomUUID();
    private final int mGroupIndex;

    protected GrpcChannelKey(GrpcNetworkGroup networkGroup, GrpcServerAddress serverAddress, int groupIndex) {
        this.mNetworkGroup = Objects.requireNonNull(networkGroup, "networkGroup is null");
        this.mServerAddress = Objects.requireNonNull(serverAddress, "serverAddress is null");
        this.mGroupIndex = groupIndex;
    }

    public UUID getChannelId() {
        return this.mChannelId;
    }

    public GrpcServerAddress getServerAddress() {
        return this.mServerAddress;
    }

    public GrpcNetworkGroup getNetworkGroup() {
        return this.mNetworkGroup;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GrpcChannelKey other = (GrpcChannelKey)o;
        return this.mNetworkGroup.equals((Object)other.mNetworkGroup) && this.mServerAddress.equals(other.mServerAddress) && this.mGroupIndex == other.mGroupIndex;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.mNetworkGroup, this.mServerAddress, this.mGroupIndex});
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("NetworkGroup", (Object)this.mNetworkGroup).add("ServerAddress", this.mServerAddress).add("GroupIndex", this.mGroupIndex).add("ChannelId", this.mChannelId).toString();
    }
}

