/*
 * Decompiled with CFR 0.152.
 */
package alluxio.network.protocol;

import alluxio.network.protocol.RPCMessage;
import alluxio.shaded.client.io.netty.buffer.ByteBuf;
import alluxio.shaded.client.io.netty.channel.ChannelHandler;
import alluxio.shaded.client.io.netty.channel.ChannelHandlerContext;
import alluxio.shaded.client.io.netty.handler.codec.MessageToMessageDecoder;
import alluxio.shaded.client.javax.annotation.concurrent.ThreadSafe;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
@ThreadSafe
public final class RPCMessageDecoder
extends MessageToMessageDecoder<ByteBuf> {
    private static final Logger LOG = LoggerFactory.getLogger(RPCMessageDecoder.class);

    @Override
    public void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) {
        RPCMessage.Type type = RPCMessage.Type.decode(in);
        RPCMessage message = RPCMessage.decodeMessage(type, in);
        out.add(message);
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        LOG.error("Error in decoding message.", cause);
        ctx.close();
    }
}

