/*
 * Decompiled with CFR 0.152.
 */
package alluxio.shaded.client.com.amazonaws.http.impl.client;

import alluxio.shaded.client.com.amazonaws.annotation.ThreadSafe;
import alluxio.shaded.client.com.amazonaws.util.AWSRequestMetrics;
import alluxio.shaded.client.org.apache.http.impl.client.DefaultHttpRequestRetryHandler;
import alluxio.shaded.client.org.apache.http.protocol.HttpContext;
import java.io.IOException;

@ThreadSafe
public class SdkHttpRequestRetryHandler
extends DefaultHttpRequestRetryHandler {
    public static final SdkHttpRequestRetryHandler Singleton = new SdkHttpRequestRetryHandler();

    private SdkHttpRequestRetryHandler() {
    }

    @Override
    public boolean retryRequest(IOException exception, int executionCount, HttpContext context) {
        AWSRequestMetrics awsRequestMetrics;
        boolean retry = super.retryRequest(exception, executionCount, context);
        if (retry && (awsRequestMetrics = (AWSRequestMetrics)context.getAttribute(AWSRequestMetrics.SIMPLE_NAME)) != null) {
            awsRequestMetrics.incrementCounter(AWSRequestMetrics.Field.HttpClientRetryCount);
        }
        return retry;
    }
}

