/*
 * Decompiled with CFR 0.152.
 */
package alluxio.shaded.client.com.amazonaws.retry.v2;

import alluxio.shaded.client.com.amazonaws.retry.v2.RetryCondition;
import alluxio.shaded.client.com.amazonaws.retry.v2.RetryPolicyContext;
import alluxio.shaded.client.com.amazonaws.util.ValidationUtils;

public class MaxNumberOfRetriesCondition
implements RetryCondition {
    private final int maxNumberOfRetries;

    public MaxNumberOfRetriesCondition(int maxNumberOfRetries) {
        this.maxNumberOfRetries = ValidationUtils.assertIsPositive(maxNumberOfRetries, "maxNumberOfRetries");
    }

    @Override
    public boolean shouldRetry(RetryPolicyContext context) {
        return context.retriesAttempted() < this.maxNumberOfRetries;
    }
}

