package alluxio.shaded.client.org.checkerframework.checker.tainting.qual;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import alluxio.shaded.client.org.checkerframework.framework.qual.DefaultFor;
import alluxio.shaded.client.org.checkerframework.framework.qual.LiteralKind;
import alluxio.shaded.client.org.checkerframework.framework.qual.QualifierForLiterals;
import alluxio.shaded.client.org.checkerframework.framework.qual.SubtypeOf;
import alluxio.shaded.client.org.checkerframework.framework.qual.TypeUseLocation;

/**
 * Denotes a reference that is untainted, i.e. can be trusted.
 *
 * @checker_framework.manual #tainting-checker Tainting Checker
 */
@Documented
@Retention(RetentionPolicy.RUNTIME)
@Target({ElementType.TYPE_USE, ElementType.TYPE_PARAMETER})
@SubtypeOf(Tainted.class)
@QualifierForLiterals(LiteralKind.STRING)
@DefaultFor(TypeUseLocation.LOWER_BOUND)
public @interface Untainted {}
