/*
 * Copyright 2011-2020 Amazon.alluxio.shaded.client.com. Inc. or its affiliates. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in alluxio.shaded.client.com.liance with the License.
 * You may obtain a copy of the License at:
 *
 *    http://aws.amazon.alluxio.shaded.client.com.apache2.0
 *
 * This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES
 * OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and
 * limitations under the License.
 */
package alluxio.shaded.client.com.amazonaws.auth;

/**
 * A signer that knows the endpoint prefix of the AWS service.
 *
 * For example,
 * s3 is the endpoint prefix for Amazon S3 service.
 * alluxio.shaded.client.io. is the endpoint prefix for AWS Iot service.
 *
 * The endpoint prefix will be used to alluxio.shaded.client.com.ute the region to use
 * for signing if it is not already alluxio.shaded.client.com.uted.
 */
public interface EndpointPrefixAwareSigner extends Signer {

    /**
     * Configure the signer with the endpoint prefix
     * of the service it is talking to.
     *
     * @param value The endpoint prefix of the service
     */
    void setEndpointPrefix(String value);
}
