/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.file.cache.store;

import alluxio.client.file.cache.CacheUsage;
import alluxio.client.file.cache.PageInfo;
import alluxio.client.file.cache.PageStore;
import alluxio.client.file.cache.evictor.CacheEvictor;
import alluxio.client.file.cache.store.MemoryPageStore;
import alluxio.client.file.cache.store.PageStoreOptions;
import alluxio.client.file.cache.store.QuotaManagedPageStoreDir;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;

public class MemoryPageStoreDir
extends QuotaManagedPageStoreDir {
    private final MemoryPageStore mPageStore;

    public MemoryPageStoreDir(PageStoreOptions pageStoreOptions, MemoryPageStore pageStore, CacheEvictor cacheEvictor) {
        super(pageStoreOptions.getRootDir(), (long)((double)pageStoreOptions.getCacheSize() / (1.0 + pageStoreOptions.getOverheadRatio())), cacheEvictor);
        this.mPageStore = Objects.requireNonNull(pageStore);
    }

    @Override
    public PageStore getPageStore() {
        return this.mPageStore;
    }

    @Override
    public void reset() {
        this.mPageStore.reset();
    }

    @Override
    public void scanPages(Consumer<Optional<PageInfo>> pageInfoConsumer) {
    }

    @Override
    public Optional<CacheUsage> getUsage() {
        return Optional.of(new QuotaManagedPageStoreDir.Usage());
    }
}

