/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.file.options;

import alluxio.client.file.FileSystemUtils;
import alluxio.client.file.options.UfsFileSystemOptions;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.shaded.client.com.google.common.base.Preconditions;
import java.util.Optional;

public class FileSystemOptions {
    private final boolean mMetadataCacheEnabled;
    private final boolean mDataCacheEnabled;
    private final boolean mDoraCacheEnabled;
    private final Optional<UfsFileSystemOptions> mUfsFileSystemOptions;

    public static FileSystemOptions create(AlluxioConfiguration conf) {
        if (conf.getBoolean(PropertyKey.DORA_CLIENT_READ_LOCATION_POLICY_ENABLED)) {
            return FileSystemOptions.create(conf, Optional.of(new UfsFileSystemOptions(conf.getString(PropertyKey.DORA_CLIENT_UFS_ROOT))));
        }
        return FileSystemOptions.create(conf, Optional.empty());
    }

    public static FileSystemOptions create(AlluxioConfiguration conf, Optional<UfsFileSystemOptions> ufsOptions) {
        return new FileSystemOptions(FileSystemUtils.metadataEnabled(conf), conf.getBoolean(PropertyKey.USER_CLIENT_CACHE_ENABLED), conf.getBoolean(PropertyKey.DORA_CLIENT_READ_LOCATION_POLICY_ENABLED), ufsOptions);
    }

    private FileSystemOptions(boolean metadataCacheEnabled, boolean dataCacheEnabled, boolean doraCacheEnabled, Optional<UfsFileSystemOptions> ufsFileSystemOptions) {
        this.mUfsFileSystemOptions = Preconditions.checkNotNull(ufsFileSystemOptions);
        this.mMetadataCacheEnabled = metadataCacheEnabled;
        this.mDataCacheEnabled = dataCacheEnabled;
        this.mDoraCacheEnabled = doraCacheEnabled;
    }

    public Optional<UfsFileSystemOptions> getUfsFileSystemOptions() {
        return this.mUfsFileSystemOptions;
    }

    public boolean isMetadataCacheEnabled() {
        return this.mMetadataCacheEnabled;
    }

    public boolean isDataCacheEnabled() {
        return this.mDataCacheEnabled;
    }

    public boolean isDoraCacheEnabled() {
        return this.mDoraCacheEnabled;
    }
}

