/*
 * Decompiled with CFR 0.152.
 */
package alluxio.collections;

import alluxio.shaded.client.javax.annotation.concurrent.ThreadSafe;
import java.util.function.Function;

@ThreadSafe
public abstract class IndexDefinition<T, V> {
    private final boolean mIsUnique;

    public IndexDefinition(boolean isUnique) {
        this.mIsUnique = isUnique;
    }

    public boolean isUnique() {
        return this.mIsUnique;
    }

    public abstract V getFieldValue(T var1);

    public static <T, V> IndexDefinition<T, V> ofUnique(final Function<T, V> definition) {
        return new IndexDefinition<T, V>(true){

            @Override
            public V getFieldValue(T o) {
                return definition.apply(o);
            }
        };
    }

    public static <T, V> IndexDefinition<T, V> ofNonUnique(final Function<T, V> definition) {
        return new IndexDefinition<T, V>(false){

            @Override
            public V getFieldValue(T o) {
                return definition.apply(o);
            }
        };
    }
}

