/*
 * Decompiled with CFR 0.152.
 */
package alluxio.util.logging;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.Marker;

public class SamplingLogger
implements Logger {
    private final Logger mDelegate;
    private final long mCooldownMs;
    private final Map<String, AtomicLong> mCooldowns = new ConcurrentHashMap<String, AtomicLong>();

    public SamplingLogger(Logger delegate, long cooldownMs) {
        this.mDelegate = delegate;
        this.mCooldownMs = cooldownMs;
    }

    private boolean acquireLogPermission(String msg) {
        AtomicLong cooldown = this.mCooldowns.computeIfAbsent(msg, m3 -> new AtomicLong(0L));
        long allowed = cooldown.get();
        long now = System.currentTimeMillis();
        return now >= allowed && cooldown.compareAndSet(allowed, now + this.mCooldownMs);
    }

    public void trace(String msg) {
        if (this.isTraceEnabled() && this.acquireLogPermission(msg)) {
            this.mDelegate.trace(msg);
        }
    }

    public void trace(String format, Object arg) {
        if (this.isTraceEnabled() && this.acquireLogPermission(format)) {
            this.mDelegate.trace(format, arg);
        }
    }

    public void trace(String format, Object arg1, Object arg2) {
        if (this.isTraceEnabled() && this.acquireLogPermission(format)) {
            this.mDelegate.trace(format, arg1, arg2);
        }
    }

    public void trace(String format, Object ... arguments) {
        if (this.isTraceEnabled() && this.acquireLogPermission(format)) {
            this.mDelegate.trace(format, arguments);
        }
    }

    public void trace(String msg, Throwable t) {
        if (this.isTraceEnabled() && this.acquireLogPermission(msg)) {
            this.mDelegate.trace(msg, t);
        }
    }

    public void trace(Marker marker, String msg) {
        if (this.isTraceEnabled() && this.acquireLogPermission(msg)) {
            this.mDelegate.trace(marker, msg);
        }
    }

    public void trace(Marker marker, String format, Object arg) {
        if (this.isTraceEnabled() && this.acquireLogPermission(format)) {
            this.mDelegate.trace(marker, format, arg);
        }
    }

    public void trace(Marker marker, String format, Object arg1, Object arg2) {
        if (this.isTraceEnabled() && this.acquireLogPermission(format)) {
            this.mDelegate.trace(marker, format, arg1, arg2);
        }
    }

    public void trace(Marker marker, String format, Object ... argArray) {
        if (this.isTraceEnabled() && this.acquireLogPermission(format)) {
            this.mDelegate.trace(marker, format, argArray);
        }
    }

    public void trace(Marker marker, String msg, Throwable t) {
        if (this.isTraceEnabled() && this.acquireLogPermission(msg)) {
            this.mDelegate.trace(marker, msg, t);
        }
    }

    public void debug(String msg) {
        if (this.isDebugEnabled() && this.acquireLogPermission(msg)) {
            this.mDelegate.debug(msg);
        }
    }

    public void debug(String format, Object arg) {
        if (this.isDebugEnabled() && this.acquireLogPermission(format)) {
            this.mDelegate.debug(format, arg);
        }
    }

    public void debug(String format, Object arg1, Object arg2) {
        if (this.isDebugEnabled() && this.acquireLogPermission(format)) {
            this.mDelegate.debug(format, arg1, arg2);
        }
    }

    public void debug(String format, Object ... arguments) {
        if (this.isDebugEnabled() && this.acquireLogPermission(format)) {
            this.mDelegate.debug(format, arguments);
        }
    }

    public void debug(String msg, Throwable t) {
        if (this.isDebugEnabled() && this.acquireLogPermission(msg)) {
            this.mDelegate.debug(msg, t);
        }
    }

    public void debug(Marker marker, String msg) {
        if (this.isDebugEnabled() && this.acquireLogPermission(msg)) {
            this.mDelegate.debug(marker, msg);
        }
    }

    public void debug(Marker marker, String format, Object arg) {
        if (this.isDebugEnabled() && this.acquireLogPermission(format)) {
            this.mDelegate.debug(marker, format, arg);
        }
    }

    public void debug(Marker marker, String format, Object arg1, Object arg2) {
        if (this.isDebugEnabled() && this.acquireLogPermission(format)) {
            this.mDelegate.debug(marker, format, arg1, arg2);
        }
    }

    public void debug(Marker marker, String format, Object ... arguments) {
        if (this.isDebugEnabled() && this.acquireLogPermission(format)) {
            this.mDelegate.debug(marker, format, arguments);
        }
    }

    public void debug(Marker marker, String msg, Throwable t) {
        if (this.isDebugEnabled() && this.acquireLogPermission(msg)) {
            this.mDelegate.debug(marker, msg, t);
        }
    }

    public void info(String msg) {
        if (this.isInfoEnabled() && this.acquireLogPermission(msg)) {
            this.mDelegate.info(msg);
        }
    }

    public void info(String format, Object arg) {
        if (this.isInfoEnabled() && this.acquireLogPermission(format)) {
            this.mDelegate.info(format, arg);
        }
    }

    public void info(String format, Object arg1, Object arg2) {
        if (this.isInfoEnabled() && this.acquireLogPermission(format)) {
            this.mDelegate.info(format, arg1, arg2);
        }
    }

    public void info(String format, Object ... arguments) {
        if (this.isInfoEnabled() && this.acquireLogPermission(format)) {
            this.mDelegate.info(format, arguments);
        }
    }

    public void info(String msg, Throwable t) {
        if (this.isInfoEnabled() && this.acquireLogPermission(msg)) {
            this.mDelegate.info(msg, t);
        }
    }

    public void info(Marker marker, String msg) {
        if (this.isInfoEnabled() && this.acquireLogPermission(msg)) {
            this.mDelegate.info(marker, msg);
        }
    }

    public void info(Marker marker, String format, Object arg) {
        if (this.isInfoEnabled() && this.acquireLogPermission(format)) {
            this.mDelegate.info(marker, format, arg);
        }
    }

    public void info(Marker marker, String format, Object arg1, Object arg2) {
        if (this.isInfoEnabled() && this.acquireLogPermission(format)) {
            this.mDelegate.info(marker, format, arg1, arg2);
        }
    }

    public void info(Marker marker, String format, Object ... arguments) {
        if (this.isInfoEnabled() && this.acquireLogPermission(format)) {
            this.mDelegate.info(marker, format, arguments);
        }
    }

    public void info(Marker marker, String msg, Throwable t) {
        if (this.isInfoEnabled() && this.acquireLogPermission(msg)) {
            this.mDelegate.info(marker, msg, t);
        }
    }

    public void warn(String msg) {
        if (this.isWarnEnabled() && this.acquireLogPermission(msg)) {
            this.mDelegate.warn(msg);
        }
    }

    public void warn(String format, Object arg) {
        if (this.isWarnEnabled() && this.acquireLogPermission(format)) {
            this.mDelegate.warn(format, arg);
        }
    }

    public void warn(String format, Object ... arguments) {
        if (this.isWarnEnabled() && this.acquireLogPermission(format)) {
            this.mDelegate.warn(format, arguments);
        }
    }

    public void warn(String format, Object arg1, Object arg2) {
        if (this.isWarnEnabled() && this.acquireLogPermission(format)) {
            this.mDelegate.warn(format, arg1, arg2);
        }
    }

    public void warn(String msg, Throwable t) {
        if (this.isWarnEnabled() && this.acquireLogPermission(msg)) {
            this.mDelegate.warn(msg, t);
        }
    }

    public void warn(Marker marker, String msg) {
        if (this.isWarnEnabled() && this.acquireLogPermission(msg)) {
            this.mDelegate.warn(marker, msg);
        }
    }

    public void warn(Marker marker, String format, Object arg) {
        if (this.isWarnEnabled() && this.acquireLogPermission(format)) {
            this.mDelegate.warn(marker, format, arg);
        }
    }

    public void warn(Marker marker, String format, Object arg1, Object arg2) {
        if (this.isWarnEnabled() && this.acquireLogPermission(format)) {
            this.mDelegate.warn(marker, format, arg1, arg2);
        }
    }

    public void warn(Marker marker, String format, Object ... arguments) {
        if (this.isWarnEnabled() && this.acquireLogPermission(format)) {
            this.mDelegate.warn(marker, format, arguments);
        }
    }

    public void warn(Marker marker, String msg, Throwable t) {
        if (this.isWarnEnabled() && this.acquireLogPermission(msg)) {
            this.mDelegate.warn(marker, msg, t);
        }
    }

    public void error(String msg) {
        if (this.isErrorEnabled() && this.acquireLogPermission(msg)) {
            this.mDelegate.error(msg);
        }
    }

    public void error(String format, Object arg) {
        if (this.isErrorEnabled() && this.acquireLogPermission(format)) {
            this.mDelegate.error(format, arg);
        }
    }

    public void error(String format, Object arg1, Object arg2) {
        if (this.isErrorEnabled() && this.acquireLogPermission(format)) {
            this.mDelegate.error(format, arg1, arg2);
        }
    }

    public void error(String format, Object ... arguments) {
        if (this.isErrorEnabled() && this.acquireLogPermission(format)) {
            this.mDelegate.error(format, arguments);
        }
    }

    public void error(String msg, Throwable t) {
        if (this.isErrorEnabled() && this.acquireLogPermission(msg)) {
            this.mDelegate.error(msg, t);
        }
    }

    public void error(Marker marker, String msg) {
        if (this.isErrorEnabled() && this.acquireLogPermission(msg)) {
            this.mDelegate.error(marker, msg);
        }
    }

    public void error(Marker marker, String format, Object arg) {
        if (this.isErrorEnabled() && this.acquireLogPermission(format)) {
            this.mDelegate.error(marker, format, arg);
        }
    }

    public void error(Marker marker, String format, Object arg1, Object arg2) {
        if (this.isErrorEnabled() && this.acquireLogPermission(format)) {
            this.mDelegate.error(marker, format, arg1, arg2);
        }
    }

    public void error(Marker marker, String format, Object ... arguments) {
        if (this.isErrorEnabled() && this.acquireLogPermission(format)) {
            this.mDelegate.error(marker, format, arguments);
        }
    }

    public void error(Marker marker, String msg, Throwable t) {
        if (this.isErrorEnabled() && this.acquireLogPermission(msg)) {
            this.mDelegate.error(marker, msg, t);
        }
    }

    public String getName() {
        return this.mDelegate.getName();
    }

    public boolean isTraceEnabled() {
        return this.mDelegate.isTraceEnabled();
    }

    public boolean isTraceEnabled(Marker marker) {
        return this.mDelegate.isTraceEnabled(marker);
    }

    public boolean isDebugEnabled() {
        return this.mDelegate.isDebugEnabled();
    }

    public boolean isDebugEnabled(Marker marker) {
        return this.mDelegate.isDebugEnabled(marker);
    }

    public boolean isInfoEnabled() {
        return this.mDelegate.isInfoEnabled();
    }

    public boolean isInfoEnabled(Marker marker) {
        return this.mDelegate.isInfoEnabled(marker);
    }

    public boolean isWarnEnabled() {
        return this.mDelegate.isWarnEnabled();
    }

    public boolean isWarnEnabled(Marker marker) {
        return this.mDelegate.isWarnEnabled(marker);
    }

    public boolean isErrorEnabled() {
        return this.mDelegate.isErrorEnabled();
    }

    public boolean isErrorEnabled(Marker marker) {
        return this.mDelegate.isErrorEnabled(marker);
    }
}

