/*
 * Decompiled with CFR 0.152.
 */
package alluxio.wire;

import alluxio.shaded.client.com.google.common.base.MoreObjects;
import alluxio.shaded.client.com.google.common.base.Objects;
import alluxio.shaded.client.com.google.common.base.Preconditions;
import alluxio.shaded.client.javax.annotation.concurrent.NotThreadSafe;
import alluxio.util.CommonUtils;
import alluxio.wire.Address;

@NotThreadSafe
public final class MasterInfo {
    private Address mAddress;
    private long mId;
    private long mLastUpdatedTimeMs;

    public MasterInfo() {
    }

    public MasterInfo(long id, Address address, long lastUpdatedTimeMs) {
        this.mAddress = Preconditions.checkNotNull(address, "address");
        this.mId = id;
        this.mLastUpdatedTimeMs = lastUpdatedTimeMs;
    }

    public MasterInfo(long id, Address address) {
        this.mAddress = Preconditions.checkNotNull(address, "address");
        this.mId = id;
        this.mLastUpdatedTimeMs = System.currentTimeMillis();
    }

    public Address getAddress() {
        return this.mAddress;
    }

    public long getId() {
        return this.mId;
    }

    public long getLastUpdatedTimeMs() {
        return this.mLastUpdatedTimeMs;
    }

    public MasterInfo setAddress(Address address) {
        this.mAddress = address;
        return this;
    }

    public MasterInfo setId(long id) {
        this.mId = id;
        return this;
    }

    public MasterInfo setLastUpdatedTimeMs(long lastUpdatedTimeMs) {
        this.mLastUpdatedTimeMs = lastUpdatedTimeMs;
        return this;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("id", this.mId).add("address", this.mAddress).add("lastUpdatedTime", CommonUtils.convertMsToClockTime(this.mLastUpdatedTimeMs)).toString();
    }

    public void updateLastUpdatedTimeMs() {
        this.mLastUpdatedTimeMs = System.currentTimeMillis();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MasterInfo)) {
            return false;
        }
        MasterInfo that = (MasterInfo)o;
        return this.mId == that.mId && Objects.equal(this.mAddress, that.mAddress) && this.mLastUpdatedTimeMs == that.mLastUpdatedTimeMs;
    }

    public int hashCode() {
        return Objects.hashCode(this.mId, this.mAddress, this.mLastUpdatedTimeMs);
    }
}

