/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.block;

import alluxio.AbstractMasterClient;
import alluxio.client.block.BlockMasterClient;
import alluxio.client.block.options.GetWorkerReportOptions;
import alluxio.grpc.BlockMasterClientServiceGrpc;
import alluxio.grpc.DecommissionWorkerPOptions;
import alluxio.grpc.GetBlockInfoPRequest;
import alluxio.grpc.GetBlockMasterInfoPOptions;
import alluxio.grpc.GetCapacityBytesPOptions;
import alluxio.grpc.GetUsedBytesPOptions;
import alluxio.grpc.GetWorkerInfoListPOptions;
import alluxio.grpc.GetWorkerLostStoragePOptions;
import alluxio.grpc.GrpcUtils;
import alluxio.grpc.RemoveDecommissionedWorkerPOptions;
import alluxio.grpc.ServiceType;
import alluxio.grpc.WorkerInfo;
import alluxio.grpc.WorkerLostStorageInfo;
import alluxio.master.MasterClientContext;
import alluxio.master.selectionpolicy.MasterSelectionPolicy;
import alluxio.retry.RetryPolicy;
import alluxio.shaded.client.javax.annotation.concurrent.ThreadSafe;
import alluxio.wire.BlockInfo;
import alluxio.wire.BlockMasterInfo;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class RetryHandlingBlockMasterClient
extends AbstractMasterClient
implements BlockMasterClient {
    private static final Logger RPC_LOG = LoggerFactory.getLogger(BlockMasterClient.class);
    private BlockMasterClientServiceGrpc.BlockMasterClientServiceBlockingStub mClient = null;

    public RetryHandlingBlockMasterClient(MasterClientContext conf) {
        super(conf);
    }

    public RetryHandlingBlockMasterClient(MasterClientContext conf, InetSocketAddress address) {
        super(conf, MasterSelectionPolicy.Factory.specifiedMaster(address));
    }

    public RetryHandlingBlockMasterClient(MasterClientContext conf, InetSocketAddress address, Supplier<RetryPolicy> retryPolicy) {
        super(conf, MasterSelectionPolicy.Factory.specifiedMaster(address), retryPolicy);
    }

    @Override
    protected ServiceType getRemoteServiceType() {
        return ServiceType.BLOCK_MASTER_CLIENT_SERVICE;
    }

    @Override
    protected String getServiceName() {
        return "BlockMasterClient";
    }

    @Override
    protected long getServiceVersion() {
        return 2L;
    }

    @Override
    protected void afterConnect() {
        this.mClient = BlockMasterClientServiceGrpc.newBlockingStub(this.mChannel);
    }

    @Override
    public List<alluxio.wire.WorkerInfo> getWorkerInfoList() throws IOException {
        return this.retryRPC(() -> {
            ArrayList<alluxio.wire.WorkerInfo> result = new ArrayList<alluxio.wire.WorkerInfo>();
            for (WorkerInfo workerInfo : this.mClient.getWorkerInfoList(GetWorkerInfoListPOptions.getDefaultInstance()).getWorkerInfosList()) {
                result.add(GrpcUtils.fromProto(workerInfo));
            }
            return result;
        }, RPC_LOG, "GetWorkerInfoList", "", new Object[0]);
    }

    @Override
    public void removeDecommissionedWorker(String workerName) throws IOException {
        this.retryRPC(() -> this.mClient.removeDecommissionedWorker(RemoveDecommissionedWorkerPOptions.newBuilder().setWorkerName(workerName).build()), RPC_LOG, "RemoveDecommissionedWorker", "", new Object[0]);
    }

    @Override
    public List<alluxio.wire.WorkerInfo> getWorkerReport(GetWorkerReportOptions options) throws IOException {
        return this.retryRPC(() -> {
            ArrayList<alluxio.wire.WorkerInfo> result = new ArrayList<alluxio.wire.WorkerInfo>();
            for (WorkerInfo workerInfo : this.mClient.getWorkerReport(options.toProto()).getWorkerInfosList()) {
                result.add(GrpcUtils.fromProto(workerInfo));
            }
            return result;
        }, RPC_LOG, "GetWorkerReport", "options=%s", options);
    }

    @Override
    public List<WorkerLostStorageInfo> getWorkerLostStorage() throws IOException {
        return this.retryRPC(() -> this.mClient.getWorkerLostStorage(GetWorkerLostStoragePOptions.getDefaultInstance()).getWorkerLostStorageInfoList(), RPC_LOG, "GetWorkerLostStorage", "", new Object[0]);
    }

    @Override
    public BlockInfo getBlockInfo(long blockId) throws IOException {
        return this.retryRPC(() -> GrpcUtils.fromProto(this.mClient.getBlockInfo(GetBlockInfoPRequest.newBuilder().setBlockId(blockId).build()).getBlockInfo()), RPC_LOG, "GetBlockInfo", "blockId=%d", blockId);
    }

    @Override
    public BlockMasterInfo getBlockMasterInfo(Set<BlockMasterInfo.BlockMasterInfoField> fields) throws IOException {
        return this.retryRPC(() -> BlockMasterInfo.fromProto(this.mClient.getBlockMasterInfo(GetBlockMasterInfoPOptions.newBuilder().addAllFilters(fields.stream().map(BlockMasterInfo.BlockMasterInfoField::toProto).collect(Collectors.toList())).build()).getBlockMasterInfo()), RPC_LOG, "GetBlockMasterInfo", "fields=%s", fields);
    }

    @Override
    public long getCapacityBytes() throws IOException {
        return this.retryRPC(() -> this.mClient.getCapacityBytes(GetCapacityBytesPOptions.getDefaultInstance()).getBytes(), RPC_LOG, "GetCapacityBytes", "", new Object[0]);
    }

    @Override
    public long getUsedBytes() throws IOException {
        return this.retryRPC(() -> this.mClient.getUsedBytes(GetUsedBytesPOptions.getDefaultInstance()).getBytes(), RPC_LOG, "GetUsedBytes", "", new Object[0]);
    }

    @Override
    public void decommissionWorker(DecommissionWorkerPOptions options) throws IOException {
        this.retryRPC(() -> this.mClient.decommissionWorker(options), RPC_LOG, "DecommissionWorker", "workerName=%s,options=%s", options.getWorkerName(), options);
    }
}

