/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.file;

import alluxio.AlluxioURI;
import alluxio.client.AlluxioStorageType;
import alluxio.client.UnderStorageType;
import alluxio.client.block.BlockStoreClient;
import alluxio.client.block.policy.options.GetWorkerOptions;
import alluxio.client.block.stream.BlockOutStream;
import alluxio.client.block.stream.UnderFileSystemFileOutStream;
import alluxio.client.file.FileOutStream;
import alluxio.client.file.FileSystemContext;
import alluxio.client.file.FileSystemMasterClient;
import alluxio.client.file.options.OutStreamOptions;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.exception.ExceptionMessage;
import alluxio.exception.PreconditionMessage;
import alluxio.exception.status.UnavailableException;
import alluxio.grpc.CompleteFilePOptions;
import alluxio.grpc.FileSystemMasterCommonPOptions;
import alluxio.metrics.MetricKey;
import alluxio.metrics.MetricsSystem;
import alluxio.resource.CloseableResource;
import alluxio.retry.ExponentialTimeBoundedRetry;
import alluxio.shaded.client.com.codahale.metrics.Counter;
import alluxio.shaded.client.com.codahale.metrics.Timer;
import alluxio.shaded.client.com.google.common.base.Preconditions;
import alluxio.shaded.client.com.google.common.io.Closer;
import alluxio.shaded.client.javax.annotation.concurrent.NotThreadSafe;
import alluxio.shaded.client.javax.annotation.concurrent.ThreadSafe;
import alluxio.util.CommonUtils;
import alluxio.util.FileSystemOptionsUtils;
import alluxio.wire.BlockInfo;
import alluxio.wire.OperationId;
import alluxio.wire.WorkerNetAddress;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class AlluxioFileOutStream
extends FileOutStream {
    private static final Logger LOG = LoggerFactory.getLogger(AlluxioFileOutStream.class);
    private final Closer mCloser = Closer.create();
    private final long mBlockSize;
    private final AlluxioStorageType mAlluxioStorageType;
    private final UnderStorageType mUnderStorageType;
    private final FileSystemContext mContext;
    private final BlockStoreClient mBlockStore;
    private final UnderFileSystemFileOutStream mUnderStorageOutputStream;
    private final OutStreamOptions mOptions;
    private boolean mCanceled;
    private boolean mClosed;
    private boolean mShouldCacheCurrentBlock;
    private BlockOutStream mCurrentBlockOutStream;
    private final List<BlockOutStream> mPreviousBlockOutStreams;
    protected final AlluxioURI mUri;

    public AlluxioFileOutStream(AlluxioURI path, OutStreamOptions options, FileSystemContext context) throws IOException {
        this.mContext = context;
        this.mCloser.register(this.mContext.blockReinit());
        try {
            this.mUri = Preconditions.checkNotNull(path, "path");
            this.mBlockSize = options.getBlockSizeBytes();
            this.mAlluxioStorageType = options.getAlluxioStorageType();
            this.mUnderStorageType = options.getUnderStorageType();
            this.mOptions = options;
            this.mBlockStore = BlockStoreClient.create(this.mContext);
            this.mPreviousBlockOutStreams = new ArrayList<BlockOutStream>();
            this.mClosed = false;
            this.mCanceled = false;
            this.mShouldCacheCurrentBlock = this.mAlluxioStorageType.isStore();
            this.mBytesWritten = 0L;
            if (!this.mUnderStorageType.isSyncPersist()) {
                this.mUnderStorageOutputStream = null;
            } else {
                AlluxioConfiguration pathConf = this.mContext.getPathConf(path);
                ExponentialTimeBoundedRetry initRetryPolicy = ExponentialTimeBoundedRetry.builder().withMaxDuration(pathConf.getDuration(PropertyKey.USER_FILE_WRITE_INIT_MAX_DURATION)).withInitialSleep(pathConf.getDuration(PropertyKey.USER_FILE_WRITE_INIT_SLEEP_MIN)).withMaxSleep(pathConf.getDuration(PropertyKey.USER_FILE_WRITE_INIT_SLEEP_MAX)).withSkipInitialSleep().build();
                Optional<Object> workerNetAddress = Optional.empty();
                while (!workerNetAddress.isPresent() && initRetryPolicy.attempt()) {
                    GetWorkerOptions getWorkerOptions = GetWorkerOptions.defaults().setBlockWorkerInfos(this.mContext.getCachedWorkers()).setBlockInfo(new BlockInfo().setBlockId(-1L).setLength(0L));
                    workerNetAddress = options.getLocationPolicy().getWorker(getWorkerOptions);
                }
                if (!workerNetAddress.isPresent()) {
                    throw new UnavailableException(ExceptionMessage.NO_WORKER_AVAILABLE.getMessage(new Object[0]));
                }
                this.mUnderStorageOutputStream = this.mCloser.register(UnderFileSystemFileOutStream.create(this.mContext, (WorkerNetAddress)workerNetAddress.get(), this.mOptions));
            }
        }
        catch (Throwable t) {
            throw CommonUtils.closeAndRethrow(this.mCloser, t);
        }
    }

    @Override
    public void cancel() throws IOException {
        this.mCanceled = true;
        this.close();
    }

    @Override
    public void close() throws IOException {
        block29: {
            if (this.mClosed) {
                return;
            }
            try (Timer.Context ctx = MetricsSystem.uniformTimer(MetricKey.CLOSE_ALLUXIO_OUTSTREAM_LATENCY.getName()).time();){
                if (this.mCurrentBlockOutStream != null) {
                    this.mPreviousBlockOutStreams.add(this.mCurrentBlockOutStream);
                }
                CompleteFilePOptions.Builder optionsBuilder = CompleteFilePOptions.newBuilder();
                optionsBuilder.setCommonOptions(FileSystemMasterCommonPOptions.newBuilder().setOperationId(new OperationId(UUID.randomUUID()).toFsProto()).buildPartial());
                if (this.mUnderStorageType.isSyncPersist()) {
                    if (this.mCanceled) {
                        this.mUnderStorageOutputStream.cancel();
                    } else {
                        this.mUnderStorageOutputStream.close();
                        optionsBuilder.setUfsLength(this.mBytesWritten);
                        this.mUnderStorageOutputStream.getDataWriter().getUfsContentHash().ifPresent(optionsBuilder::setContentHash);
                    }
                }
                if (this.mAlluxioStorageType.isStore()) {
                    if (this.mCanceled) {
                        for (BlockOutStream bos : this.mPreviousBlockOutStreams) {
                            bos.cancel();
                        }
                    } else {
                        if (this.mCurrentBlockOutStream != null) {
                            this.mCurrentBlockOutStream.close();
                        }
                        for (BlockOutStream bos : this.mPreviousBlockOutStreams) {
                            bos.close();
                        }
                    }
                }
                if (!this.mCanceled && this.mUnderStorageType.isAsyncPersist() && this.mOptions.getPersistenceWaitTime() != -1L) {
                    optionsBuilder.setAsyncPersistOptions(FileSystemOptionsUtils.scheduleAsyncPersistDefaults(this.mContext.getPathConf(this.mUri)).toBuilder().setCommonOptions(this.mOptions.getCommonOptions()).setPersistenceWaitTime(this.mOptions.getPersistenceWaitTime()));
                }
                if (this.mCanceled || !this.mUnderStorageType.isSyncPersist() && !this.mAlluxioStorageType.isStore()) break block29;
                try (CloseableResource<FileSystemMasterClient> masterClient = this.mContext.acquireMasterClientResource();){
                    masterClient.get().completeFile(this.mUri, optionsBuilder.build());
                }
            }
            catch (Throwable e) {
                throw this.mCloser.rethrow(e);
            }
            finally {
                this.mClosed = true;
                this.mCloser.close();
            }
        }
    }

    @Override
    public void flush() throws IOException {
        if (this.mUnderStorageType.isSyncPersist()) {
            this.mUnderStorageOutputStream.flush();
        }
    }

    @Override
    public void write(int b) throws IOException {
        this.writeInternal(b);
    }

    @Override
    public void write(byte[] b) throws IOException {
        Preconditions.checkArgument(b != null, (Object)PreconditionMessage.ERR_WRITE_BUFFER_NULL);
        this.writeInternal(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.writeInternal(b, off, len);
    }

    private void writeInternal(int b) throws IOException {
        if (this.mShouldCacheCurrentBlock) {
            try {
                if (this.mCurrentBlockOutStream == null || this.mCurrentBlockOutStream.remaining() == 0L) {
                    this.getNextBlock();
                }
                this.mCurrentBlockOutStream.write(b);
            }
            catch (IOException e) {
                this.handleCacheWriteException(e);
            }
        }
        if (this.mUnderStorageType.isSyncPersist()) {
            this.mUnderStorageOutputStream.write(b);
            Metrics.BYTES_WRITTEN_UFS.inc();
        }
        ++this.mBytesWritten;
    }

    private void writeInternal(byte[] b, int off, int len) throws IOException {
        Preconditions.checkArgument(b != null, (Object)PreconditionMessage.ERR_WRITE_BUFFER_NULL);
        Preconditions.checkArgument(off >= 0 && len >= 0 && len + off <= b.length, PreconditionMessage.ERR_BUFFER_STATE.toString(), (Object)b.length, (Object)off, (Object)len);
        if (this.mShouldCacheCurrentBlock) {
            try {
                int tLen = len;
                int tOff = off;
                while (tLen > 0) {
                    long currentBlockLeftBytes;
                    if (this.mCurrentBlockOutStream == null || this.mCurrentBlockOutStream.remaining() == 0L) {
                        this.getNextBlock();
                    }
                    if ((currentBlockLeftBytes = this.mCurrentBlockOutStream.remaining()) >= (long)tLen) {
                        this.mCurrentBlockOutStream.write(b, tOff, tLen);
                        tLen = 0;
                        continue;
                    }
                    this.mCurrentBlockOutStream.write(b, tOff, (int)currentBlockLeftBytes);
                    tOff = (int)((long)tOff + currentBlockLeftBytes);
                    tLen = (int)((long)tLen - currentBlockLeftBytes);
                }
            }
            catch (Exception e) {
                this.handleCacheWriteException(e);
            }
        }
        if (this.mUnderStorageType.isSyncPersist()) {
            this.mUnderStorageOutputStream.write(b, off, len);
            Metrics.BYTES_WRITTEN_UFS.inc(len);
        }
        this.mBytesWritten += (long)len;
    }

    private void getNextBlock() throws IOException {
        if (this.mCurrentBlockOutStream != null) {
            Preconditions.checkState(this.mCurrentBlockOutStream.remaining() <= 0L, "The current block still has space left, no need to get new block");
            this.mCurrentBlockOutStream.flush();
            this.mPreviousBlockOutStreams.add(this.mCurrentBlockOutStream);
        }
        if (this.mAlluxioStorageType.isStore()) {
            this.mCurrentBlockOutStream = this.mBlockStore.getOutStream(this.getNextBlockId(), this.mBlockSize, this.mOptions);
            this.mShouldCacheCurrentBlock = true;
        }
    }

    private long getNextBlockId() throws IOException {
        try (CloseableResource<FileSystemMasterClient> masterClient = this.mContext.acquireMasterClientResource();){
            long l = masterClient.get().getNewBlockIdForFile(this.mUri);
            return l;
        }
    }

    private void handleCacheWriteException(Exception e) throws IOException {
        LOG.warn("Failed to write into AlluxioStore, canceling write attempt.", (Throwable)e);
        if (!this.mUnderStorageType.isSyncPersist()) {
            this.mCanceled = true;
            throw new IOException(ExceptionMessage.FAILED_CACHE.getMessage(e.getMessage()), e);
        }
        if (this.mCurrentBlockOutStream != null) {
            this.mShouldCacheCurrentBlock = false;
            this.mCurrentBlockOutStream.cancel();
        }
    }

    @ThreadSafe
    private static final class Metrics {
        private static final Counter BYTES_WRITTEN_UFS = MetricsSystem.counter(MetricKey.CLIENT_BYTES_WRITTEN_UFS.getName());

        private Metrics() {
        }
    }
}

