/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.file.cache;

import alluxio.client.file.cache.CacheManagerOptions;
import alluxio.client.file.cache.CacheStatus;
import alluxio.client.file.cache.DefaultPageMetaStore;
import alluxio.client.file.cache.PageId;
import alluxio.client.file.cache.PageInfo;
import alluxio.client.file.cache.QuotaPageMetaStore;
import alluxio.client.file.cache.store.PageStoreDir;
import alluxio.client.quota.CacheScope;
import alluxio.exception.PageNotFoundException;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.locks.ReadWriteLock;

public interface PageMetaStore
extends CacheStatus {
    public static PageMetaStore create(CacheManagerOptions options) throws IOException {
        List<PageStoreDir> dirs = PageStoreDir.createPageStoreDirs(options);
        if (options.isQuotaEnabled()) {
            return new QuotaPageMetaStore(options.getCacheEvictorOptions(), dirs);
        }
        return new DefaultPageMetaStore(dirs);
    }

    public ReadWriteLock getLock();

    public boolean hasPage(PageId var1);

    public void addPage(PageId var1, PageInfo var2);

    public void addTempPage(PageId var1, PageInfo var2);

    public void commitFile(String var1, String var2) throws PageNotFoundException;

    public List<PageStoreDir> getStoreDirs();

    public PageStoreDir allocate(String var1, long var2);

    public PageInfo getPageInfo(PageId var1) throws PageNotFoundException;

    public PageInfo removePage(PageId var1, boolean var2) throws PageNotFoundException;

    public PageInfo removePage(PageId var1) throws PageNotFoundException;

    public long bytes();

    public long numPages();

    public void reset();

    default public PageInfo evict(PageStoreDir pageStoreDir) {
        return this.evict(CacheScope.GLOBAL, pageStoreDir);
    }

    public PageInfo evict(CacheScope var1, PageStoreDir var2);
}

